/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.io;

import org.ijsberg.iglu.util.io.Filter;
import org.ijsberg.iglu.util.io.Receiver;
import org.ijsberg.iglu.util.io.Transmitter;

public class Pipe
implements Transmitter {
    private Receiver receiver;
    private Filter<Object> filter;
    private boolean isClosed;

    public Pipe() {
    }

    public Pipe(Receiver receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException("receiver may not be null");
        }
        this.receiver = receiver;
    }

    public Pipe(Receiver receiver, Filter<?> filter) {
        if (receiver == null) {
            throw new IllegalArgumentException("receiver may not be null");
        }
        this.receiver = receiver;
        this.filter = filter;
    }

    @Override
    public void transmit(Object object) {
        if (this.isClosed) {
            throw new IllegalStateException("pipe is closed");
        }
        if (this.filter != null) {
            this.receiver.onReceive(this.filter.filter(object));
        } else {
            this.receiver.onReceive(object);
        }
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            throw new IllegalStateException("pipe is closed");
        }
        this.receiver.onTransmissionClose();
        this.receiver = null;
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public Filter addFilter(Filter filter) {
        this.filter = filter;
        return filter;
    }
}

