/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.io;

import java.util.LinkedList;
import org.ijsberg.iglu.util.io.Queue;
import org.ijsberg.iglu.util.io.Receiver;

public class ReceiverQueue
implements Receiver,
Queue {
    private LinkedList queue = new LinkedList();
    private int limit;
    private boolean closed;

    public ReceiverQueue() {
    }

    public ReceiverQueue(int limit) {
        this.limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceive(Object object) {
        if (!this.closed && object != null) {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addLast(object);
                if (this.limit > 0 && this.queue.size() > this.limit && !this.queue.isEmpty()) {
                    this.queue.removeFirst();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (!this.queue.isEmpty()) {
                return this.queue.removeFirst();
            }
        }
        return null;
    }

    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void onTransmissionClose() {
        this.close();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.clear();
        }
    }

    public int getNrofQueuedMessages() {
        return this.queue.size();
    }

    @Override
    public int available() {
        return this.queue.size();
    }

    public int getLimit() {
        return this.limit;
    }
}

