/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.ijsberg.iglu.util.io.Channel;
import org.ijsberg.iglu.util.io.Queue;
import org.ijsberg.iglu.util.io.Receiver;
import org.ijsberg.iglu.util.io.ReceiverQueue;
import org.ijsberg.iglu.util.io.Transmitter;

public class Transponder
implements Receiver {
    private Transmitter outputTransmitter;
    private InputStream inputStream;
    public static final long DEFAULT_POLLING_INTERVAL = 10L;
    private long pollingInterval = 10L;
    public static final int DEFAULT_QUEUE_SIZE = 0;
    private int queueSize = 0;
    public static final int DEFAULT_BUFFER_SIZE = 80;
    private int bufferSize = 80;
    private ReceiverQueue receiverQueue;
    private Queue queue;
    private boolean haltRequest;
    protected Thread forwarderThread;

    public Transponder(Transmitter outputTransmitter) {
        if (outputTransmitter == null) {
            throw new IllegalArgumentException("transmitter may not be null");
        }
        this.outputTransmitter = outputTransmitter;
        this.receiverQueue = new ReceiverQueue(this.queueSize);
        this.queue = this.receiverQueue;
        this.forwarderThread = new Thread(new Forwarder());
    }

    public Transponder(Queue queue, Transmitter outputTransmitter) {
        if (queue == null) {
            throw new IllegalArgumentException("queue may not be null");
        }
        if (outputTransmitter == null) {
            throw new IllegalArgumentException("transmitter may not be null");
        }
        this.outputTransmitter = outputTransmitter;
        this.queue = queue;
        this.forwarderThread = new Thread(new Forwarder());
    }

    public Transponder(Channel channel, Transmitter outputTransmitter) {
        if (channel == null) {
            throw new IllegalArgumentException("channel may not be null");
        }
        if (outputTransmitter == null) {
            throw new IllegalArgumentException("transmitter may not be null");
        }
        this.outputTransmitter = outputTransmitter;
        this.receiverQueue = new ReceiverQueue(this.queueSize);
        this.queue = this.receiverQueue;
        channel.registerReceiver(this.receiverQueue);
        this.forwarderThread = new Thread(new Forwarder());
    }

    public Transponder(InputStream inputStream, Transmitter outputTransmitter) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream may not be null");
        }
        if (outputTransmitter == null) {
            throw new IllegalArgumentException("transmitter may not be null");
        }
        this.inputStream = inputStream;
        this.outputTransmitter = outputTransmitter;
        this.forwarderThread = new Thread(new Forwarder());
    }

    public void start() {
        this.forwarderThread.start();
    }

    public void stop() {
        this.haltRequest = true;
    }

    @Override
    public void onReceive(Object message) {
        if (this.receiverQueue == null) {
            throw new IllegalStateException("transponder is configured to retransmit messages from alternate source only");
        }
        this.receiverQueue.onReceive(message);
    }

    @Override
    public void onTransmissionClose() {
        if (this.receiverQueue != null) {
            this.receiverQueue.onTransmissionClose();
        }
    }

    private class Forwarder
    implements Runnable {
        private Forwarder() {
        }

        @Override
        public void run() {
            while (!Transponder.this.haltRequest) {
                if (Transponder.this.inputStream != null) {
                    try {
                        byte[] buffer = new byte[Transponder.this.bufferSize];
                        int count = 0;
                        while (count >= 0) {
                            count = Transponder.this.inputStream.read(buffer);
                            if (count > 0) {
                                byte[] message = new byte[count];
                                System.arraycopy(buffer, 0, message, 0, count);
                                Transponder.this.outputTransmitter.transmit(message);
                            }
                            if (!Transponder.this.outputTransmitter.isClosed()) continue;
                            Transponder.this.stop();
                        }
                    }
                    catch (IOException e) {
                        Transponder.this.outputTransmitter.transmit("stream can no longer be forwarded...".getBytes());
                        Transponder.this.stop();
                    }
                } else {
                    while (Transponder.this.queue.available() > 0) {
                        Transponder.this.outputTransmitter.transmit(Transponder.this.queue.read());
                    }
                    if (Transponder.this.queue.isClosed()) {
                        Transponder.this.stop();
                    }
                    if (Transponder.this.outputTransmitter.isClosed()) {
                        Transponder.this.stop();
                    }
                }
                try {
                    Thread.sleep(Transponder.this.pollingInterval);
                }
                catch (InterruptedException ie) {
                    Transponder.this.stop();
                }
            }
            if (Transponder.this.queue != null && !Transponder.this.queue.isClosed()) {
                Transponder.this.queue.close();
            }
            if (Transponder.this.receiverQueue != null && !Transponder.this.receiverQueue.isClosed()) {
                Transponder.this.receiverQueue.close();
            }
            if (Transponder.this.outputTransmitter != null && !Transponder.this.outputTransmitter.isClosed()) {
                Transponder.this.outputTransmitter.close();
            }
        }
    }
}

