/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.logic;

import java.util.ArrayList;
import java.util.HashMap;
import org.ijsberg.iglu.util.logic.LogicalElement;
import org.ijsberg.iglu.util.logic.Operator;
import org.ijsberg.iglu.util.logic.Statement;

public class Expression
extends Statement {
    private static HashMap cache = new HashMap();
    private ArrayList elements = new ArrayList();
    private Object[] elementsArray;
    private Operator operator;

    private void copy(Expression expression) {
        this.operator = expression.operator;
        this.elementsArray = expression.elementsArray;
        this.elements = expression.elements;
    }

    private Expression(Operator operator, Object[] elementsArray) {
        this.operator = operator;
        this.elementsArray = elementsArray;
        for (int i = 0; i < elementsArray.length; ++i) {
            this.elements.add(elementsArray[i]);
        }
    }

    public Expression(String expression) {
        this(expression, false);
    }

    public Expression(String expression, boolean useCache) {
        int i;
        if (useCache && cache.containsKey(expression)) {
            this.copy((Expression)cache.get(expression));
            return;
        }
        StringBuffer currentStatement = new StringBuffer();
        Object currentExpression = null;
        block7: for (i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            switch (c) {
                case ')': {
                    throw new IllegalArgumentException("can't parse expression [" + expression + "] error at character " + i);
                }
                case '(': {
                    int endOfSubExpression = Expression.findEndOfSubExpression(expression, i);
                    if (endOfSubExpression == -1 || endOfSubExpression < i || currentStatement.length() > 0) {
                        throw new IllegalArgumentException("can't parse expression [" + expression + "] error at character " + i);
                    }
                    String subExpressionStr = expression.substring(i + 1, endOfSubExpression);
                    Expression subExpression = new Expression(subExpressionStr);
                    this.elements.add(subExpression);
                    i = endOfSubExpression;
                    continue block7;
                }
                case '&': {
                    this.addStatement(currentStatement);
                    this.elements.add(new Operator(2));
                    continue block7;
                }
                case '|': {
                    this.addStatement(currentStatement);
                    this.elements.add(new Operator(3));
                    continue block7;
                }
                case '!': {
                    this.addStatement(currentStatement);
                    if (i + 1 >= expression.length()) continue block7;
                    this.elements.add(new Operator(1));
                    continue block7;
                }
                default: {
                    currentStatement.append(c);
                }
            }
        }
        this.addStatement(currentStatement);
        this.elementsArray = this.elements.toArray();
        for (i = 0; i < this.elementsArray.length; ++i) {
            Operator operator;
            if (!(this.elementsArray[i] instanceof Operator) || (operator = (Operator)this.elementsArray[i]).getType() != 1) continue;
            if (i != this.elementsArray.length - 1 && !(this.elementsArray[i + 1] instanceof Operator)) {
                this.elements.add(i + 2, new Expression(operator, new Object[]{this.elementsArray[i + 1]}));
                this.elements.remove(i);
                this.elements.remove(i);
                this.elementsArray = this.elements.toArray();
                continue;
            }
            throw new IllegalArgumentException("can't parse expression [" + expression + ']');
        }
        this.compact(expression, 2);
        this.compact(expression, 3);
        if (useCache) {
            cache.put(expression, this);
        }
    }

    private void compact(String expression, int operatorType) {
        this.elementsArray = this.elements.toArray();
        for (int i = 0; i < this.elementsArray.length; ++i) {
            Operator operator;
            if (!(this.elementsArray[i] instanceof Operator) || (operator = (Operator)this.elementsArray[i]).getType() != operatorType) continue;
            if (i != this.elementsArray.length - 1 && i > 0 && !(this.elementsArray[i - 1] instanceof Operator) && !(this.elementsArray[i + 1] instanceof Operator)) {
                if (this.elementsArray[i - 1] instanceof Expression && ((Expression)this.elementsArray[i - 1]).getOperatorType() == operatorType) {
                    ((Expression)this.elementsArray[i - 1]).addElement((LogicalElement)this.elementsArray[i + 1]);
                    this.elements.remove(i);
                    this.elements.remove(i);
                    this.elementsArray = this.elements.toArray();
                    --i;
                    continue;
                }
                this.elements.add(i + 2, new Expression(operator, new Object[]{this.elementsArray[i - 1], this.elementsArray[i + 1]}));
                this.elements.remove(i - 1);
                this.elements.remove(i - 1);
                this.elements.remove(i - 1);
                this.elementsArray = this.elements.toArray();
                --i;
                continue;
            }
            throw new IllegalArgumentException("can't parse expression [" + expression + ']');
        }
    }

    private int getOperatorType() {
        if (this.operator != null) {
            return this.operator.getType();
        }
        return 0;
    }

    private boolean addStatement(StringBuffer statementBuffer) {
        if (statementBuffer.length() > 0) {
            this.elements.add(new Statement(statementBuffer.toString()));
            this.elementsArray = this.elements.toArray();
            statementBuffer.delete(0, statementBuffer.length());
            return true;
        }
        return false;
    }

    public static int findEndOfSubExpression(String expression, int start) {
        int count = 0;
        block4: for (int i = start; i < expression.length(); ++i) {
            switch (expression.charAt(i)) {
                case '(': {
                    ++count;
                    continue block4;
                }
                case ')': {
                    if (--count != 0) continue block4;
                    return i;
                }
            }
        }
        throw new IllegalArgumentException("can't parse expression [" + expression + "]: end of subexpression not found");
    }

    private void addElement(LogicalElement e) {
        this.elements.add(e);
        this.elementsArray = this.elements.toArray();
    }

    public boolean match(String statement) {
        return this.match(new Object[]{statement});
    }

    @Override
    public boolean match(Object[] statements) {
        boolean result = true;
        if (this.operator == null) {
            return ((Statement)this.elementsArray[0]).match(statements);
        }
        switch (this.operator.getType()) {
            case 1: {
                return !((Statement)this.elementsArray[0]).match(statements);
            }
            case 2: {
                for (int i = 0; i < this.elementsArray.length; ++i) {
                    result = result && ((Statement)this.elementsArray[i]).match(statements);
                }
                break;
            }
            case 3: {
                result = false;
                for (int i = 0; i < this.elementsArray.length; ++i) {
                    result = result || ((Statement)this.elementsArray[i]).match(statements);
                }
                break;
            }
        }
        return result;
    }

    @Override
    public String toString() {
        if (this.operator != null) {
            return this.operator.toString() + '(' + this.elements + ')';
        }
        return this.elements.toString();
    }

    public static void clearCache() {
        cache.clear();
    }

    public int getNrofElements() {
        return this.elements.size();
    }

    public boolean isSingleStatement() {
        if (this.elements.size() == 1) {
            if (this.elementsArray[0] instanceof Expression) {
                return ((Expression)this.elementsArray[0]).isSingleStatement();
            }
            return true;
        }
        return false;
    }

    @Override
    public String getStatement() {
        if (this.elements.size() == 1) {
            if (this.elementsArray[0] instanceof Expression) {
                return ((Expression)this.elementsArray[0]).getStatement();
            }
            if (this.elementsArray[0] instanceof Statement) {
                return ((Statement)this.elementsArray[0]).getStatement();
            }
        }
        return this.statement;
    }
}

