/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public abstract class EncodingSupport {
    public static final String base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public static String encodeBase64(byte[] rawData) {
        return EncodingSupport.encodeBase64(rawData, 0);
    }

    public static String encodeBase64(byte[] rawData, int lineLength) {
        int i;
        if (rawData == null) {
            return "";
        }
        StringBuffer retval = new StringBuffer();
        int n = 0;
        for (i = 0; i < rawData.length - 2; i += 3) {
            if (lineLength > 0 && i > 0 && i % lineLength == 0) {
                retval.append("\n");
            }
            n = (rawData[i] << 24 >>> 8) + (rawData[i + 1] << 24 >>> 16) + (rawData[i + 2] << 24 >>> 24);
            retval.append(base64Chars.charAt(n >>> 18 & 0x3F));
            retval.append(base64Chars.charAt(n >>> 12 & 0x3F));
            retval.append(base64Chars.charAt(n >>> 6 & 0x3F));
            retval.append(base64Chars.charAt(n & 0x3F));
        }
        if (i + 1 == rawData.length) {
            n = rawData[i] << 24 >>> 8;
            retval.append(base64Chars.charAt(n >>> 18 & 0x3F));
            retval.append(base64Chars.charAt(n >>> 12 & 0x3F));
            retval.append("==");
        }
        if (i + 2 == rawData.length) {
            n = (rawData[i] << 24 >>> 8) + (rawData[i + 1] << 24 >>> 16);
            retval.append(base64Chars.charAt(n >>> 18 & 0x3F));
            retval.append(base64Chars.charAt(n >>> 12 & 0x3F));
            retval.append(base64Chars.charAt(n >>> 6 & 0x3F));
            retval.append('=');
        }
        return retval.toString();
    }

    public static byte[] decodeBase64(String encodedData) {
        BufferedReader reader = new BufferedReader(new StringReader(encodedData));
        int length = encodedData.length();
        byte[] retval = new byte[length];
        int actualLength = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                byte[] rawData = line.getBytes();
                int n = 0;
                for (int i = 0; i < rawData.length; i += 4) {
                    n = base64Chars.indexOf(rawData[i]) << 18 | base64Chars.indexOf(rawData[i + 1]) << 12;
                    retval[actualLength++] = (byte)(n >>> 16 & 0xFF);
                    if (rawData[i + 2] != 61) {
                        retval[actualLength++] = (byte)((n |= base64Chars.indexOf(rawData[i + 2]) << 6) >>> 8 & 0xFF);
                    }
                    if (rawData[i + 3] == 61) continue;
                    retval[actualLength++] = (byte)((n |= base64Chars.indexOf(rawData[i + 3])) & 0xFF);
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("exception while reading input with message: " + ioe);
        }
        if (actualLength != length) {
            byte[] actualRetval = new byte[actualLength];
            System.arraycopy(retval, 0, actualRetval, 0, actualLength);
            return actualRetval;
        }
        return retval;
    }
}

