/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.time;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class SafeDateFormat {
    private final ThreadLocal dateFormat;

    public SafeDateFormat(final DateFormat aDateFormat) {
        this.dateFormat = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                DateFormat dateFormat = (DateFormat)aDateFormat.clone();
                dateFormat.setLenient(false);
                return dateFormat;
            }
        };
    }

    public SafeDateFormat(final String simpleDateFormat) {
        this.dateFormat = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                SimpleDateFormat dateFormat = new SimpleDateFormat(simpleDateFormat);
                dateFormat.setLenient(false);
                return dateFormat;
            }
        };
    }

    public SafeDateFormat(final String simpleDateFormat, final DateFormatSymbols symbols) {
        this.dateFormat = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                SimpleDateFormat dateFormat = new SimpleDateFormat(simpleDateFormat, symbols);
                dateFormat.setLenient(false);
                return dateFormat;
            }
        };
    }

    public String format(Date date) {
        return ((DateFormat)this.dateFormat.get()).format(date);
    }

    public Date parse(String dateStr) throws ParseException {
        return ((DateFormat)this.dateFormat.get()).parse(dateStr);
    }
}

