/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.time;

import org.ijsberg.iglu.util.time.TimeSupport;

public class SchedulingSupport
extends TimeSupport {
    public static int getIntervalsSinceMidnight(long time, int intervalInMinutes) {
        return (int)((time += LOCAL_UTC_OFFSET) - 86400000L * ((time + 30000L) / 86400000L)) / (60000 * intervalInMinutes);
    }

    public static long getPreviousIntervalStart(long time, int intervalInMinutes) {
        return SchedulingSupport.getPreviousIntervalStart(time, intervalInMinutes, 0);
    }

    public static boolean isIntervalRegularDaily(int intervalInMinutes) {
        return 1440 % intervalInMinutes == 0;
    }

    public static long calculateOffsetInMs(int intervalInMinutes, int offsetInMinutes) {
        while (offsetInMinutes < 0) {
            offsetInMinutes = intervalInMinutes + offsetInMinutes;
        }
        while (offsetInMinutes > intervalInMinutes) {
            offsetInMinutes -= intervalInMinutes;
        }
        return offsetInMinutes * 60000;
    }

    public static long getPreviousIntervalStart(long time, int intervalInMinutes, int offsetInMinutes) {
        long interval = 60000 * intervalInMinutes;
        long offset = SchedulingSupport.calculateOffsetInMs(intervalInMinutes, offsetInMinutes);
        return interval * ((time + LOCAL_UTC_OFFSET - offset) / interval) + offset - LOCAL_UTC_OFFSET;
    }

    public static long getNextIntervalStart(long time, int intervalInMinutes) {
        return SchedulingSupport.getNextIntervalStart(time, intervalInMinutes, 0);
    }

    public static long getNextIntervalStart(long time, int intervalInMinutes, int offsetInMinutes) {
        long interval = 60000 * intervalInMinutes;
        return SchedulingSupport.getPreviousIntervalStart(time, intervalInMinutes, offsetInMinutes) + interval;
    }

    public static boolean isWithinSameInterval(long time1, long time2, int intervalInMinutes) {
        return SchedulingSupport.getPreviousIntervalStart(time1, intervalInMinutes) == SchedulingSupport.getPreviousIntervalStart(time2, intervalInMinutes);
    }

    public static boolean isWithinSameInterval(long time1, long time2, int intervalInMinutes, int offsetInMinutes) {
        return SchedulingSupport.getPreviousIntervalStart(time1, intervalInMinutes, offsetInMinutes) == SchedulingSupport.getPreviousIntervalStart(time2, intervalInMinutes, offsetInMinutes);
    }

    public static boolean isWithinMinuteOfIntervalStart(long time, int intervalInMinutes) {
        return SchedulingSupport.isWithinMinuteOfIntervalStart(time, intervalInMinutes, 0);
    }

    public static boolean isWithinMinuteOfIntervalStart(long time, int intervalInMinutes, int offsetInMinutes) {
        long interval = 60000 * intervalInMinutes;
        long offset = SchedulingSupport.calculateOffsetInMs(intervalInMinutes, offsetInMinutes);
        return interval * (((time += LOCAL_UTC_OFFSET) + 30000L) / interval) + offset == SchedulingSupport.roundToMinute(time);
    }

    public static long getTimeTillIntervalStart(long time, int intervalInMinutes) {
        return SchedulingSupport.getNextIntervalStart(time, intervalInMinutes) - time;
    }

    public static long getTimeTillIntervalStart(long time, int intervalInMinutes, int offsetInMinutes) {
        return SchedulingSupport.getNextIntervalStart(time, intervalInMinutes, offsetInMinutes) - time;
    }
}

