/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.time;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.ijsberg.iglu.util.time.SchedulingSupport;

public abstract class TimeSupport {
    public static final int SECOND_IN_MS = 1000;
    public static final int MINUTE_IN_MS = 60000;
    public static final int HALF_MINUTE_IN_MS = 30000;
    public static final int HOUR_IN_MS = 3600000;
    public static final int DAY_IN_MS = 86400000;
    public static final int DAY_IN_MINS = 1440;
    public static final long LOCAL_UTC_OFFSET = TimeSupport.getLocalUtcOffset();
    public static final long LOCAL_UTC_OFFSET_IN_MINUTES = LOCAL_UTC_OFFSET / 60000L;

    private static long getLocalUtcOffset() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        return TimeSupport.getUtcOffset(cal);
    }

    public static long getUtcOffset(Calendar cal) {
        return cal.get(16) + cal.get(15);
    }

    public static boolean isToday(Date date) {
        GregorianCalendar calInput = new GregorianCalendar();
        calInput.setTime(date);
        GregorianCalendar calToday = new GregorianCalendar();
        calToday.setTime(new Date());
        return calInput.get(6) == calToday.get(6) && calInput.get(1) == calToday.get(1);
    }

    public static boolean isBeforeToday(Date date) {
        GregorianCalendar calInput = new GregorianCalendar();
        calInput.setTime(date);
        GregorianCalendar calToday = new GregorianCalendar();
        calToday.setTime(new Date());
        return calInput.get(1) * 1000 + calInput.get(6) < calToday.get(1) * 1000 + calToday.get(6);
    }

    public static boolean isAfterToday(Date date) {
        GregorianCalendar calInput = new GregorianCalendar();
        calInput.setTime(date);
        GregorianCalendar calToday = new GregorianCalendar();
        calToday.setTime(new Date());
        return calInput.get(1) * 1000 + calInput.get(6) > calToday.get(1) * 1000 + calToday.get(6);
    }

    public static boolean isSameDay(long time1, long time2) {
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(new Date(time1));
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(new Date(time2));
        return cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameWeek(long time1, long time2) {
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(new Date(time1));
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(new Date(time2));
        return cal1.get(3) == cal2.get(3);
    }

    public static long roundToMinute(long time) {
        return 60000L * ((time + 30000L) / 60000L);
    }

    public static int getMinutesSinceMidnight() {
        return TimeSupport.getMinutesSinceMidnight(System.currentTimeMillis());
    }

    public static int getMinutesSinceMidnight(long time) {
        return SchedulingSupport.getIntervalsSinceMidnight(time, 1);
    }
}

