/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.types;

import java.util.Arrays;
import org.ijsberg.iglu.util.reflection.ReflectionSupport;

public abstract class Converter {
    public static Integer convertToInteger(Object input) {
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (input instanceof Number) {
            return new Integer(((Number)input).intValue());
        }
        if (input instanceof Character) {
            return new Integer(((Character)input).charValue());
        }
        return new Integer(input.toString());
    }

    public static Long convertToLong(Object input) {
        if (input instanceof Long) {
            return (Long)input;
        }
        if (input instanceof Number) {
            return new Long(((Number)input).longValue());
        }
        if (input instanceof Character) {
            return new Long(((Character)input).charValue());
        }
        return new Long(input.toString());
    }

    public static Short convertToShort(Object input) {
        if (input instanceof Short) {
            return (Short)input;
        }
        if (input instanceof Number) {
            return new Short(((Number)input).shortValue());
        }
        if (input instanceof Character) {
            return (short)((Character)input).charValue();
        }
        return new Short(input.toString());
    }

    public static Byte convertToByte(Object input) {
        if (input instanceof Byte) {
            return (Byte)input;
        }
        if (input instanceof Number) {
            return new Byte(((Number)input).byteValue());
        }
        if (input instanceof Character) {
            return (byte)((Character)input).charValue();
        }
        return new Byte(input.toString());
    }

    public static Float convertToFloat(Object input) {
        if (input instanceof Float) {
            return (Float)input;
        }
        if (input instanceof Number) {
            return new Float(((Number)input).floatValue());
        }
        return new Float(input.toString());
    }

    public static Double convertToDouble(Object input) {
        if (input instanceof Double) {
            return (Double)input;
        }
        if (input instanceof Number) {
            return new Double(((Number)input).doubleValue());
        }
        return new Double(input.toString());
    }

    public static Boolean convertToBoolean(Object input) {
        if (input instanceof Boolean) {
            return (Boolean)input;
        }
        if (input instanceof Number) {
            return ((Number)input).doubleValue() != 0.0;
        }
        return Boolean.valueOf(input.toString());
    }

    public static Character convertToCharacter(Object input) {
        if (input instanceof Character) {
            return (Character)input;
        }
        if (input instanceof Number) {
            return new Character((char)Integer.parseInt(input.toString()));
        }
        String s = input.toString();
        if (s.length() > 0) {
            return new Character(s.charAt(0));
        }
        return new Character('\u0000');
    }

    protected static Object convertToPrimitive(Object source, Class type) {
        if ("byte".equals(type.getName())) {
            return Converter.convertToByte(source);
        }
        if ("char".equals(type.getName())) {
            return Converter.convertToCharacter(source);
        }
        if ("double".equals(type.getName())) {
            return Converter.convertToDouble(source);
        }
        if ("float".equals(type.getName())) {
            return Converter.convertToFloat(source);
        }
        if ("int".equals(type.getName())) {
            return Converter.convertToInteger(source);
        }
        if ("long".equals(type.getName())) {
            return Converter.convertToLong(source);
        }
        if ("short".equals(type.getName())) {
            return Converter.convertToShort(source);
        }
        if ("boolean".equals(type.getName())) {
            return Converter.convertToBoolean(source);
        }
        throw new IllegalArgumentException("can not convert '" + source + "' (" + type.getName() + ") to primitive");
    }

    public static Object convertToObject(Object source, Class type) {
        if (source == null) {
            return null;
        }
        if (type.isAssignableFrom(source.getClass())) {
            return source;
        }
        if (type.isPrimitive()) {
            return Converter.convertToPrimitive(source, type);
        }
        if (source instanceof String && (Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type))) {
            try {
                return ReflectionSupport.instantiateClass(type, source);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("can not convert '" + source + "' to type " + type + " with message: " + e.getMessage());
            }
        }
        if (type == String.class) {
            return source.toString();
        }
        throw new IllegalArgumentException("can not convert '" + source + "' to type " + type);
    }

    public static Object[] convertToMatchingTypes(Object[] objects, Class[] targetTypes) {
        Object[] alternativeObjects = new Object[objects.length];
        if (targetTypes.length == objects.length) {
            for (int j = 0; j < objects.length; ++j) {
                alternativeObjects[j] = objects[j] == null || targetTypes[j] == objects[j].getClass() ? objects[j] : Converter.convertToObject(objects[j], targetTypes[j]);
            }
            return alternativeObjects;
        }
        throw new IllegalArgumentException("arguments " + Arrays.asList(objects) + " can not be converted to types " + Arrays.asList(targetTypes));
    }
}

