/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.configuration.module;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ijsberg.iglu.configuration.Cluster;
import org.ijsberg.iglu.configuration.Component;
import org.ijsberg.iglu.configuration.ConfigurationException;
import org.ijsberg.iglu.configuration.Facade;

public class StandardCluster
implements Cluster,
Facade,
InvocationHandler {
    private HashMap<String, Set<Class<?>>> exposedInterfacesByComponentId = new HashMap();
    private Set<Component> externalComponents = new HashSet<Component>();
    private HashMap<String, Component> internalComponentsById = new HashMap();

    public boolean isConnected(Component component) {
        return this.isConnectedInternally(component) || this.isConnectedExternally(component);
    }

    public boolean isConnectedInternally(Component component) {
        return this.internalComponentsById.values().contains(component);
    }

    public boolean isConnectedExternally(Component component) {
        return this.externalComponents.contains(component);
    }

    public boolean isExposed(String componentId) {
        return this.exposedInterfacesByComponentId.containsKey(componentId);
    }

    @Override
    public void connect(String componentId, Component component) throws ConfigurationException {
        if (this.isConnectedExternally(component)) {
            throw new ConfigurationException("component " + component + " is already connected as external component");
        }
        this.ensureIdNotRegisteredByOther(componentId);
        this.internalComponentsById.put(componentId, component);
        this.setDependenciesForNewInternalComponent(componentId, component);
        this.registerExternalComponentAsListener(componentId, component);
    }

    @Override
    public void connect(String componentId, Component component, Class<?> ... exposedInterfaces) throws ConfigurationException {
        this.ensureComponentExposesInterfaces(component, Arrays.asList(exposedInterfaces));
        this.connect(componentId, component);
        this.setExposedInterfaces(componentId, component, exposedInterfaces);
        this.registerExternalComponentAsListener(componentId, component);
    }

    private void setExposedInterfaces(String componentId, Component component, Class<?> ... exposedInterfaces) {
        this.exposedInterfacesByComponentId.put(componentId, new HashSet(Arrays.asList(exposedInterfaces)));
        this.setInterfacesInExternalComponents(componentId, component);
    }

    @Override
    public void connect(Component externalComponent) throws ConfigurationException {
        if (this.isConnected(externalComponent)) {
            throw new ConfigurationException("component " + externalComponent + " is already connected");
        }
        this.externalComponents.add(externalComponent);
        this.setInterfacesForNewExternalComponent(externalComponent);
        this.registerNewExternalComponent(externalComponent);
    }

    @Override
    public void disconnect(Component component) {
        if (this.isConnectedInternally(component)) {
            Set<String> componentIds = this.lookUpComponentIds(component);
            for (String componentId : componentIds) {
                if (this.isExposed(componentId)) {
                    this.removeInterfacesForExternalComponents(componentId, component);
                }
                this.unregisterExternalListeners(componentId, component);
                this.exposedInterfacesByComponentId.remove(componentId);
                this.removeDependenciesForInternalComponent(componentId, component);
                this.internalComponentsById.remove(componentId);
            }
        } else if (this.isConnectedExternally(component)) {
            this.removeDependenciesForExternalComponent(component);
            this.externalComponents.remove(component);
        }
    }

    private void setInterfacesInExternalComponents(String newExposedComponentId, Component newExposedComponent) {
        this.setInterfacesInExternalComponents(newExposedComponentId, this.getExposedInterfaces(newExposedComponentId));
    }

    private void setInterfacesInExternalComponents(String exposedComponentId, Class<?>[] exposedInterfaces) {
        for (Component externalComponent : this.externalComponents) {
            externalComponent.setReference(this.getFacade(), exposedComponentId, exposedInterfaces);
        }
    }

    private void registerExternalComponentAsListener(String newExposedComponentId, Component newExposedComponent) {
        for (Component externalComponent : this.externalComponents) {
            newExposedComponent.register(externalComponent);
        }
    }

    private void removeInterfacesForExternalComponents(String exposedComponentId, Component exposedComponent) {
        for (Component externalComponent : this.externalComponents) {
            externalComponent.removeDependency(exposedComponentId);
        }
    }

    private void unregisterExternalListeners(String exposedComponentId, Component exposedComponent) {
        for (Component externalComponent : this.externalComponents) {
            exposedComponent.unregister(externalComponent);
        }
    }

    private void setDependenciesForNewInternalComponent(String componentId, Component component) {
        for (String internalComponentId : this.internalComponentsById.keySet()) {
            if (internalComponentId.equals(componentId)) continue;
            Component internalComponent = this.internalComponentsById.get(internalComponentId);
            internalComponent.setReference(this, componentId, component.getInterfaces());
            internalComponent.register(component);
            component.setReference(this, internalComponentId, internalComponent.getInterfaces());
            component.register(internalComponent);
        }
    }

    private void removeDependenciesForInternalComponent(String componentId, Component component) {
        for (String internalComponentId : this.internalComponentsById.keySet()) {
            if (internalComponentId.equals(componentId)) continue;
            Component internalComponent = this.internalComponentsById.get(internalComponentId);
            internalComponent.removeDependency(componentId);
            internalComponent.unregister(component);
            component.removeDependency(internalComponentId);
            component.unregister(internalComponent);
        }
    }

    private void setInterfacesForNewExternalComponent(Component externalComponent) {
        for (String internalComponentId : this.internalComponentsById.keySet()) {
            if (!this.isExposed(internalComponentId)) continue;
            externalComponent.setReference(this.getFacade(), internalComponentId, this.getExposedInterfaces(internalComponentId));
        }
    }

    private void registerNewExternalComponent(Component externalComponent) {
        for (String internalComponentId : this.internalComponentsById.keySet()) {
            Component internalComponent = this.internalComponentsById.get(internalComponentId);
            internalComponent.register(externalComponent);
        }
    }

    private void removeDependenciesForExternalComponent(Component externalComponent) {
        for (String internalComponentId : this.internalComponentsById.keySet()) {
            if (this.isExposed(internalComponentId)) {
                externalComponent.removeDependency(internalComponentId);
            }
            Component internalComponent = this.internalComponentsById.get(internalComponentId);
            internalComponent.unregister(externalComponent);
        }
    }

    private void ensureIdNotRegisteredByOther(String componentId) {
        if (this.internalComponentsById.containsKey(componentId)) {
            throw new ConfigurationException("component already registered under id '" + componentId + "'");
        }
    }

    private void ensureComponentExposesInterfaces(Component component, List<Class<?>> requestedInterfaces) {
        List<Class<?>> componentInterfaces = Arrays.asList(component.getInterfaces());
        for (Class<?> exposedInterface : requestedInterfaces) {
            if (componentInterfaces.contains(exposedInterface)) continue;
            throw new IllegalArgumentException("component '" + component + "' does not expose interface " + exposedInterface);
        }
    }

    @Override
    public Set<String> getExposedComponentIds() {
        return this.exposedInterfacesByComponentId.keySet();
    }

    @Override
    public Class<?>[] getExposedInterfaces(String componentId) {
        if (!this.isExposed(componentId)) {
            throw new ConfigurationException("component with id '" + componentId + "' is not exposed");
        }
        return this.exposedInterfacesByComponentId.get(componentId).toArray(new Class[0]);
    }

    @Override
    public Object getProxy(String componentId, Class<?> exposedInterface) {
        Component component = this.getInternalComponent(componentId);
        return component.getProxy(exposedInterface);
    }

    private Component getInternalComponent(String componentId) {
        return this.internalComponentsById.get(componentId);
    }

    private Set<String> lookUpComponentIds(Component component) {
        HashSet<String> retval = new HashSet<String>();
        for (String componentId : this.internalComponentsById.keySet()) {
            if (this.internalComponentsById.get(componentId) != component) continue;
            retval.add(componentId);
        }
        return retval;
    }

    private boolean isExposed(String componentId, Class<?> interfaceClass) {
        Set<Class<?>> exposedInterfaces = this.exposedInterfacesByComponentId.get(componentId);
        return exposedInterfaces != null && exposedInterfaces.contains(interfaceClass);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Object retval;
        if (method.getName().equals("getProxy") && !this.isExposed((String)arguments[0], (Class)arguments[1])) {
            throw new ConfigurationException((String)arguments[0] + " does not expose " + arguments[1]);
        }
        try {
            retval = method.invoke((Object)this, arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        return retval;
    }

    @Override
    public Facade getFacade() {
        return (Facade)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Facade.class}, (InvocationHandler)this);
    }

    @Override
    public Map<String, Component> getInternalComponents() {
        return new HashMap<String, Component>(this.internalComponentsById);
    }

    @Override
    public Set<Component> getExternalComponents() {
        return new HashSet<Component>(this.externalComponents);
    }

    @Override
    public void expose(String internalComponentId, Class<?> ... interfaces) {
        if (!this.internalComponentsById.containsKey(internalComponentId)) {
            throw new ConfigurationException("component '" + internalComponentId + "' is not connected");
        }
        if (this.isExposed(internalComponentId) && (interfaces == null || interfaces.length == 0)) {
            this.exposedInterfacesByComponentId.remove(internalComponentId);
            this.removeInterfacesForExternalComponents(internalComponentId, this.getInternalComponent(internalComponentId));
        }
        this.ensureComponentExposesInterfaces(this.getInternalComponent(internalComponentId), Arrays.asList(interfaces));
        this.exposedInterfacesByComponentId.put(internalComponentId, new HashSet(Arrays.asList(interfaces)));
        this.setInterfacesInExternalComponents(internalComponentId, interfaces);
    }
}

