/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.configuration.module;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.ijsberg.iglu.configuration.Component;
import org.ijsberg.iglu.configuration.ConfigurationException;
import org.ijsberg.iglu.configuration.Facade;
import org.ijsberg.iglu.util.reflection.MethodInvocation;
import org.ijsberg.iglu.util.reflection.ReflectionSupport;
import org.ijsberg.iglu.util.types.Converter;

public class StandardComponent
implements Component,
InvocationHandler {
    public static final String PROPERTIES_PROPERTY_KEY = "properties";
    public static final String REGISTER_LISTENER_METHOD_NAME = "register";
    public static final String UNREGISTER_LISTENER_METHOD_NAME = "unregister";
    private Object implementation;
    private Class<?>[] interfaces;
    private Properties properties;
    private Properties setterInjectedProperties = new Properties();
    private HashMap<Class<?>, InvocationHandler> invocationHandlers = new HashMap();
    private HashMap<String, Set<Class<?>>> injectedProxyTypesByComponentId = new HashMap();
    private Map<Component, Map<Class<?>, Object>> registeredListenersByComponent = new HashMap();

    public StandardComponent(Object implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation can not be null");
        }
        this.implementation = implementation;
        this.interfaces = ReflectionSupport.getInterfacesForClass(implementation.getClass()).toArray(new Class[0]);
    }

    @Override
    public void setReference(Facade facade, String componentId, Class<?> ... interfaces) {
        if (this.injectedProxyTypesByComponentId.containsKey(componentId)) {
            this.resetReference(facade, componentId, interfaces);
        } else {
            HashSet<Class<?>> injectedProxyTypes = this.injectProxies(componentId, Arrays.asList(interfaces), facade);
            this.injectedProxyTypesByComponentId.put(componentId, injectedProxyTypes);
        }
    }

    private void resetReference(Facade facade, String componentId, Class<?>[] interfaces) {
        Set<Class<Class<?>>> currentlyInjectedInterfaces = this.injectedProxyTypesByComponentId.get(componentId);
        HashSet exposedInterfaces = new HashSet(Arrays.asList(interfaces));
        HashSet interfacesToBeRemoved = new HashSet(currentlyInjectedInterfaces);
        interfacesToBeRemoved.removeAll(exposedInterfaces);
        currentlyInjectedInterfaces.removeAll(interfacesToBeRemoved);
        this.injectNulls(componentId, interfacesToBeRemoved);
        HashSet interfacesToAdd = new HashSet(exposedInterfaces);
        interfacesToAdd.removeAll(currentlyInjectedInterfaces);
        HashSet<Class<?>> injectedProxyTypes = this.injectProxies(componentId, interfacesToAdd, facade);
        currentlyInjectedInterfaces.addAll(injectedProxyTypes);
        if (currentlyInjectedInterfaces.isEmpty()) {
            this.injectedProxyTypesByComponentId.remove(componentId);
        }
    }

    @Override
    public void removeDependency(String componentId) {
        this.injectNulls(componentId, this.injectedProxyTypesByComponentId.get(componentId));
        this.injectedProxyTypesByComponentId.remove(componentId);
    }

    @Override
    public void register(Component component) {
        for (Class<?> interfaceClass : component.getInterfaces()) {
            try {
                Method method = this.implementation.getClass().getMethod(REGISTER_LISTENER_METHOD_NAME, interfaceClass);
                Object listenerProxy = component.getProxy(interfaceClass);
                this.invokeMethod(method, listenerProxy);
                this.saveRegisteredListenerProxy(component, interfaceClass, listenerProxy);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
        }
    }

    @Override
    public void unregister(Component component) {
        Map<Class<?>, Object> registeredListeners = this.registeredListenersByComponent.get(component);
        if (registeredListeners != null) {
            for (Class<?> interfaceClass : component.getInterfaces()) {
                try {
                    Method method = this.implementation.getClass().getMethod(UNREGISTER_LISTENER_METHOD_NAME, interfaceClass);
                    Object listenerProxy = registeredListeners.get(interfaceClass);
                    if (listenerProxy == null) continue;
                    this.invokeMethod(method, listenerProxy);
                    registeredListeners.remove(interfaceClass);
                }
                catch (NoSuchMethodException ignore) {
                    // empty catch block
                }
            }
        }
    }

    private void saveRegisteredListenerProxy(Component component, Class<?> interfaceClass, Object listenerProxy) {
        Map<Class<?>, Object> registeredListeners = this.registeredListenersByComponent.get(component);
        if (registeredListeners == null) {
            registeredListeners = new HashMap();
            this.registeredListenersByComponent.put(component, registeredListeners);
        }
        registeredListeners.put(interfaceClass, listenerProxy);
    }

    private HashSet<Class<?>> injectProxies(String otherComponentId, Collection<Class<?>> interfaces, Facade facade) {
        HashSet injectedProxyTypes = new HashSet();
        for (Method setter : this.getComponentSettersByPropertyKey(otherComponentId)) {
            for (Class<?> interfaceClass : interfaces) {
                if (!setter.getParameterTypes()[0].isAssignableFrom(interfaceClass)) continue;
                Object proxy = facade.getProxy(otherComponentId, interfaceClass);
                this.invokeMethod(setter, proxy);
                injectedProxyTypes.add(interfaceClass);
            }
        }
        return injectedProxyTypes;
    }

    private void injectNulls(String otherComponentId, Set<Class<?>> interfaces) {
        for (Method setter : this.getComponentSettersByPropertyKey(otherComponentId)) {
            for (Class<?> interfaceClass : interfaces) {
                if (!setter.getParameterTypes()[0].isAssignableFrom(interfaceClass)) continue;
                this.invokeMethod(setter, null);
            }
        }
    }

    @Override
    public Object getProxy(Class<?> interfaceClass) {
        this.checkInterfaceValidity(interfaceClass);
        return Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)this);
    }

    private void checkInterfaceValidity(Class<?> interfaceClass) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("class " + interfaceClass.getName() + " is not an interface");
        }
        if (!interfaceClass.isAssignableFrom(this.implementation.getClass())) {
            throw new IllegalArgumentException("class " + this.implementation.getClass().getName() + " does not implement " + interfaceClass.getName());
        }
    }

    @Override
    public Class<?>[] getInterfaces() {
        return this.interfaces;
    }

    @Override
    public void setProperties(Properties properties) {
        for (Object key : properties.keySet()) {
            String value = properties.getProperty((String)key);
            this.injectPropertyIfMatchingSetterFound((String)key, value);
        }
        this.injectPropertyIfMatchingSetterFound(PROPERTIES_PROPERTY_KEY, properties);
        this.properties = properties;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public Properties getSetterInjectedProperties() {
        return this.setterInjectedProperties;
    }

    private Set<Method> getComponentSettersByPropertyKey(String key) {
        String setterName = "set" + StandardComponent.makeFirstCharUpperCase(key);
        return ReflectionSupport.getMethodsByName(this.implementation.getClass(), setterName, 1);
    }

    public static String makeFirstCharUpperCase(String varName) {
        StringBuffer keyStrBuf = new StringBuffer(varName);
        keyStrBuf.replace(0, 1, String.valueOf(keyStrBuf.charAt(0)).toUpperCase());
        return keyStrBuf.toString();
    }

    private void injectPropertyIfMatchingSetterFound(String key, Object value) {
        Set<Method> setters = this.getComponentSettersByPropertyKey(key);
        if (setters.size() > 1) {
            throw new ConfigurationException("more than 1 (" + setters.size() + ") setter found for property '" + key + "'");
        }
        if (setters.size() == 1) {
            this.injectProperty(setters.iterator().next(), value);
            this.setterInjectedProperties.put(key, value);
        }
    }

    private void injectProperty(Method method, Object value) {
        Object injectingObject = Converter.convertToObject(value, method.getParameterTypes()[0]);
        this.invokeMethod(method, injectingObject);
    }

    private void invokeMethod(Method method, Object injectingObject) {
        try {
            method.invoke(this.implementation, injectingObject);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ite.getCause();
            }
            throw new RuntimeException("can't invoke method '" + method.getName() + "'" + " with argument " + injectingObject, ite.getCause());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("can't invoke method '" + method.getName() + "'" + " with argument " + injectingObject, e);
        }
    }

    @Override
    public void setInvocationIntercepter(Class<?> interfaceClass, InvocationHandler handler) {
        this.checkInterfaceValidity(interfaceClass);
        this.invocationHandlers.put(interfaceClass, handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
        InvocationHandler handler = this.invocationHandlers.get(proxy.getClass().getInterfaces()[0]);
        if (handler == null) {
            handler = this.invocationHandlers.get(method.getDeclaringClass());
        }
        if (handler != null) {
            return handler.invoke(this.implementation, method, parameters);
        }
        return method.invoke(this.implementation, parameters);
    }

    @Override
    public Object invoke(String methodName, Object ... parameters) throws InvocationTargetException, NoSuchMethodException, IllegalArgumentException {
        MethodInvocation invocation = new MethodInvocation(this, this.implementation, methodName, this.getInterfaceMethodsByName(methodName, parameters.length).toArray(new Method[0]), parameters);
        return invocation.invoke();
    }

    private Set<Method> getInterfaceMethodsByName(String methodName, int nrofParameters) {
        HashSet<Method> retval = new HashSet<Method>();
        for (Class<?> clasz : this.interfaces) {
            retval.addAll(ReflectionSupport.getMethodsByName(clasz, methodName, nrofParameters));
        }
        return retval;
    }

    @Override
    public Set<Class<?>> getInjectedInterfaces(String componentId) {
        HashSet retval = new HashSet();
        if (this.injectedProxyTypesByComponentId.containsKey(componentId)) {
            retval.addAll((Collection)this.injectedProxyTypesByComponentId.get(componentId));
        }
        return retval;
    }
}

