/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.reflection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.ijsberg.iglu.util.types.Converter;

public class MethodInvocation {
    private Object impl;
    private Method[] methods;
    private String methodName;
    private Object[] initArgs;
    private IllegalArgumentException failedInvocation = null;
    private Object retval = null;
    private boolean invocationSucceeded;
    private InvocationHandler invocationHandler;

    public MethodInvocation(InvocationHandler invocationHandler, Object impl, String methodName, Method[] methodSubset, Object ... arguments) {
        this.impl = impl;
        this.invocationHandler = invocationHandler;
        this.methods = methodSubset;
        this.methodName = methodName;
        this.initArgs = arguments;
        if (this.initArgs == null) {
            this.initArgs = new Object[0];
        }
    }

    public MethodInvocation(Object impl, String methodName, Object ... arguments) {
        this.impl = impl;
        this.methods = impl.getClass().getDeclaredMethods();
        this.methodName = methodName;
        this.initArgs = arguments;
        if (this.initArgs == null) {
            this.initArgs = new Object[0];
        }
    }

    public Object invoke() throws InvocationTargetException, NoSuchMethodException {
        this.retval = null;
        this.invocationSucceeded = false;
        if (this.invocationHandler == null) {
            this.tryInvokeExactSignature();
        }
        if (!this.invocationSucceeded) {
            this.tryInvokeWithConvertedArguments();
        }
        if (this.invocationSucceeded) {
            return this.retval;
        }
        if (this.failedInvocation != null) {
            throw this.failedInvocation;
        }
        throw new NoSuchMethodException("method not found or arguments " + Arrays.asList(this.initArgs) + " not suitable for method '" + this.methodName + "'");
    }

    private void tryInvokeWithConvertedArguments() throws InvocationTargetException {
        for (int i = 0; i < this.methods.length; ++i) {
            if (!this.methods[i].getName().equals(this.methodName) || this.methods[i].getParameterTypes().length != this.initArgs.length) continue;
            try {
                this.invokePublicMethod(this.impl, this.initArgs, this.methods[i]);
                this.invocationSucceeded = true;
                return;
            }
            catch (IllegalArgumentException iae) {
                this.failedInvocation = iae;
            }
        }
    }

    private void tryInvokeExactSignature() throws InvocationTargetException {
        try {
            Method method = this.impl.getClass().getMethod(this.methodName, MethodInvocation.getInitArgTypes(this.initArgs));
            this.invokePublicMethod(this.impl, this.initArgs, method);
            this.invocationSucceeded = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private static Class<?>[] getInitArgTypes(Object[] initArgs) {
        Class[] types = new Class[initArgs.length];
        for (int i = 0; i < initArgs.length; ++i) {
            types[i] = initArgs[i] != null ? initArgs[i].getClass() : null;
        }
        return types;
    }

    private void invokePublicMethod(Object impl, Object[] initArgs, Method method) throws InvocationTargetException {
        Class<?>[] inputTypes = method.getParameterTypes();
        Object[] alternativeInitArgs = Converter.convertToMatchingTypes(initArgs, inputTypes);
        try {
            if (this.invocationHandler != null) {
                this.invokeInvocationHandler(impl, alternativeInitArgs, method);
            } else {
                this.retval = method.invoke(impl, alternativeInitArgs);
            }
        }
        catch (IllegalAccessException privateOrProtectedInvoked) {
            throw new RuntimeException("illegal (private or protected) method '" + method.getName() + "' invoked", privateOrProtectedInvoked);
        }
    }

    private Object invokeInvocationHandler(Object impl, Object[] initArgs, Method method) throws InvocationTargetException {
        try {
            this.retval = this.invocationHandler.invoke(impl, method, initArgs);
            return this.retval;
        }
        catch (InvocationTargetException t) {
            throw t;
        }
        catch (IllegalArgumentException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
    }
}

