/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.ijsberg.iglu.util.reflection.MethodInvocation;
import org.ijsberg.iglu.util.types.Converter;

public class ReflectionSupport {
    public static ArrayList<Class<?>> getAllSuperClassesFromClass(Class<?> clasz) {
        ArrayList result = new ArrayList();
        while (clasz.getSuperclass() != null) {
            result.add(clasz.getSuperclass());
            clasz = clasz.getSuperclass();
        }
        return result;
    }

    public static ArrayList<Class<?>> getInterfacesForClass(Class<?> clasz) {
        ArrayList result = new ArrayList();
        ArrayList<Class<?>> superClasses = ReflectionSupport.getAllSuperClassesFromClass(clasz);
        superClasses.add(clasz);
        for (Class<?> superClass : superClasses) {
            Class<?>[] interfaces = superClass.getInterfaces();
            for (int j = 0; j < interfaces.length; ++j) {
                if (result.contains(interfaces[j])) continue;
                result.add(interfaces[j]);
            }
        }
        return result;
    }

    public static Object invokeMethod(Object impl, String methodName, Object ... arguments) throws NoSuchMethodException, InvocationTargetException {
        return new MethodInvocation(impl, methodName, arguments).invoke();
    }

    public static Object instantiateClass(String className) throws InstantiationException {
        try {
            return Class.forName(className).newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new InstantiationException("can not instantiate class " + className + " with message: " + iae.getClass().getName() + ": " + iae.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new InstantiationException("class " + className + " can not be found with message: " + cnfe.getMessage());
        }
    }

    public static Object instantiateClass(String className, Object ... initArgs) throws InstantiationException {
        try {
            Class<?> c = Class.forName(className);
            return ReflectionSupport.instantiateClass(c, initArgs);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InstantiationException("class " + className + " can not be found with message: " + cnfe.getMessage());
        }
    }

    public static Object instantiateClass(ClassLoader classloader, String className, Object ... initArgs) throws InstantiationException {
        try {
            Class<?> clasz = classloader.loadClass(className);
            return ReflectionSupport.instantiateClass(clasz, initArgs);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InstantiationException("class " + className + " can not be found with message: " + cnfe.getMessage());
        }
    }

    public static Object instantiateClass(Class<?> clasz, Object ... initArgs) throws InstantiationException {
        if (initArgs == null) {
            initArgs = new Object[]{};
        }
        Constructor<?>[] constructors = clasz.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Object[] alternativeInitArgs;
            Class<?>[] inputTypes;
            if (!Modifier.isPublic(constructors[i].getModifiers()) || (inputTypes = constructors[i].getParameterTypes()).length != initArgs.length || (alternativeInitArgs = Converter.convertToMatchingTypes(initArgs, inputTypes)) == null) continue;
            return ReflectionSupport.instantiateClass(clasz, constructors[i], alternativeInitArgs);
        }
        throw new InstantiationException("can not instantiate class " + clasz.getName() + ": no matching constructor for init args " + initArgs);
    }

    private static Object instantiateClass(Class<?> clasz, Constructor<?> constructor, Object ... initArgs) throws InstantiationException {
        try {
            return constructor.newInstance(initArgs);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)ite.getTargetException();
            }
            if (ite.getTargetException() instanceof Error) {
                throw (Error)ite.getTargetException();
            }
            throw new InstantiationException("can not instantiate class " + clasz.getName() + " due to exception in constructor with message: " + ite.getTargetException().getClass().getName() + ": " + ite.getTargetException().getMessage() + ", for init args " + initArgs);
        }
        catch (IllegalAccessException iae) {
            throw new InstantiationException("can not instantiate class " + clasz.getName() + " with message: " + iae.getClass().getName() + ": " + iae.getMessage() + ", for init args " + initArgs);
        }
    }

    public static Set<Method> getMethodsByName(Class<?> clasz, String methodName, int requiredNrofParameters) {
        HashSet<Method> retval = new HashSet<Method>();
        Method[] methods = clasz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!methodName.equals(method.getName()) || method.getParameterTypes().length != requiredNrofParameters) continue;
            retval.add(method);
        }
        return retval;
    }
}

