/*
 * Decompiled with CFR 0.152.
 */
package org.illyasviel.elide.spring.boot.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideSettingsBuilder;
import com.yahoo.elide.audit.AuditLogger;
import com.yahoo.elide.audit.Slf4jLogger;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.filter.dialect.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.dialect.SubqueryFilterDialect;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.security.checks.Check;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import org.atteo.classindex.ClassIndex;
import org.hibernate.ScrollMode;
import org.illyasviel.elide.spring.boot.annotation.ElideCheck;
import org.illyasviel.elide.spring.boot.datastore.SpringHibernateDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class, WebMvcAutoConfiguration.class})
public class ElideAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ElideAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public Elide elide(PlatformTransactionManager txManager, EntityManager entityManager, ObjectMapper objectMapper) {
        ConcurrentHashMap<String, Class<Check>> checks = new ConcurrentHashMap<String, Class<Check>>();
        for (Class clazz : ClassIndex.getAnnotated(ElideCheck.class)) {
            ElideCheck elideCheck = clazz.getAnnotation(ElideCheck.class);
            if (!Check.class.isAssignableFrom(clazz)) continue;
            logger.debug("Register Elide Check [{}] with expression [{}]", (Object)clazz.getCanonicalName(), (Object)elideCheck.value());
            checks.put(elideCheck.value(), clazz.asSubclass(Check.class));
        }
        EntityDictionary entityDictionary = new EntityDictionary(checks);
        RSQLFilterDialect rsqlFilterDialect = new RSQLFilterDialect(entityDictionary);
        SpringHibernateDataStore springDataStore = new SpringHibernateDataStore(txManager, entityManager, true, ScrollMode.FORWARD_ONLY);
        return new Elide(new ElideSettingsBuilder((DataStore)springDataStore).withJsonApiMapper(new JsonApiMapper(entityDictionary, objectMapper)).withAuditLogger((AuditLogger)new Slf4jLogger()).withEntityDictionary(entityDictionary).withJoinFilterDialect((JoinFilterDialect)rsqlFilterDialect).withSubqueryFilterDialect((SubqueryFilterDialect)rsqlFilterDialect).build());
    }
}

