/*
 * Decompiled with CFR 0.152.
 */
package org.illyasviel.elide.spring.boot.datastore;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.datastores.hibernate5.HibernateTransaction;
import java.io.IOException;
import org.hibernate.HibernateException;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public class SpringHibernateTransaction
extends HibernateTransaction {
    private final Session session;
    private final TransactionStatus txStatus;
    private final PlatformTransactionManager txManager;

    protected SpringHibernateTransaction(Session session, PlatformTransactionManager txManager, TransactionStatus txStatus, boolean isScrollEnabled, ScrollMode scrollMode) {
        super(session, isScrollEnabled, scrollMode);
        this.session = session;
        this.txManager = txManager;
        this.txStatus = txStatus;
    }

    public void commit(RequestScope scope) {
        try {
            this.flush(scope);
            this.txManager.commit(this.txStatus);
        }
        catch (HibernateException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.session.isOpen() && !this.txStatus.isCompleted()) {
            this.txManager.rollback(this.txStatus);
            throw new IOException("Transaction not closed");
        }
    }
}

