/*
 * Decompiled with CFR 0.152.
 */
package org.illyasviel.elide.spring.boot.datastore;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.EntityDictionary;
import java.util.Objects;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Type;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.illyasviel.elide.spring.boot.autoconfigure.ElideProperties;
import org.illyasviel.elide.spring.boot.datastore.SpringHibernateTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringHibernateDataStore
implements DataStore {
    private static final Logger logger = LoggerFactory.getLogger(SpringHibernateDataStore.class);
    protected final PlatformTransactionManager txManager;
    protected final AutowireCapableBeanFactory beanFactory;
    protected final EntityManager entityManager;
    protected final ElideProperties elideProperties;
    protected final boolean isScrollEnabled;
    protected final ScrollMode scrollMode;
    protected final HibernateTransactionSupplier transactionSupplier;

    public SpringHibernateDataStore(PlatformTransactionManager txManager, AutowireCapableBeanFactory beanFactory, EntityManager entityManager, ElideProperties elideProperties, boolean isScrollEnabled, ScrollMode scrollMode) {
        this(txManager, beanFactory, entityManager, elideProperties, isScrollEnabled, scrollMode, SpringHibernateTransaction::new);
    }

    protected SpringHibernateDataStore(PlatformTransactionManager txManager, AutowireCapableBeanFactory beanFactory, EntityManager entityManager, ElideProperties elideProperties, boolean isScrollEnabled, ScrollMode scrollMode, HibernateTransactionSupplier transactionSupplier) {
        this.txManager = txManager;
        this.beanFactory = beanFactory;
        this.entityManager = entityManager;
        this.elideProperties = elideProperties;
        this.isScrollEnabled = isScrollEnabled;
        this.scrollMode = scrollMode;
        this.transactionSupplier = transactionSupplier;
    }

    public void populateEntityDictionary(EntityDictionary dictionary) {
        if (this.elideProperties.isSpringDependencyInjection()) {
            logger.info("Spring Dependency Injection is enabled, each time an object of entityClass type is instantiated by Elide, Spring will try to inject beans.");
        }
        Set entities = this.entityManager.getMetamodel().getEntities();
        entities.stream().map(Type::getJavaType).filter(Objects::nonNull).forEach(mappedClass -> {
            try {
                dictionary.lookupEntityClass(mappedClass);
                dictionary.bindEntity(mappedClass);
                if (this.elideProperties.isSpringDependencyInjection()) {
                    dictionary.bindInitializer(arg_0 -> ((AutowireCapableBeanFactory)this.beanFactory).autowireBean(arg_0), mappedClass);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    public DataStoreTransaction beginTransaction() {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("elide transaction");
        def.setPropagationBehavior(0);
        TransactionStatus txStatus = this.txManager.getTransaction((TransactionDefinition)def);
        Session session = (Session)this.entityManager.unwrap(Session.class);
        Preconditions.checkNotNull((Object)session);
        return this.transactionSupplier.get(session, this.txManager, txStatus, this.isScrollEnabled, this.scrollMode);
    }

    @FunctionalInterface
    public static interface HibernateTransactionSupplier {
        public SpringHibernateTransaction get(Session var1, PlatformTransactionManager var2, TransactionStatus var3, boolean var4, ScrollMode var5);
    }
}

