/*
 * Decompiled with CFR 0.152.
 */
package org.illyasviel.elide.spring.boot.autoconfigure;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.illyasviel.elide.spring.boot.autoconfigure.ElideAutoConfiguration;
import org.illyasviel.elide.spring.boot.autoconfigure.ElideProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.HandlerMapping;

@Configuration
@EnableConfigurationProperties(value={ElideProperties.class})
@AutoConfigureAfter(value={ElideAutoConfiguration.class})
@ConditionalOnProperty(prefix="elide.mvc", value={"enable"}, havingValue="true", matchIfMissing=true)
public class ElideControllerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ElideControllerAutoConfiguration.class);
    static final String JSON_API_CONTENT_TYPE = "application/vnd.api+json";

    private static String getJsonApiPath(HttpServletRequest request, String prefix) {
        String pathname = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        logger.debug("[{}][{}] forward to elide.", (Object)request.getMethod(), (Object)pathname);
        return pathname.replaceFirst(prefix, "");
    }

    @Configuration
    @RestController
    @RequestMapping(value={"${elide.prefix:/api}"}, produces={"application/vnd.api+json"})
    @ConditionalOnProperty(prefix="elide.mvc", value={"delete"}, havingValue="true", matchIfMissing=true)
    public static class ElideDeleteController {
        private final Elide elide;
        private final ElideProperties elideProperties;

        @Autowired
        public ElideDeleteController(Elide elide, ElideProperties elideProperties) {
            this.elide = elide;
            this.elideProperties = elideProperties;
        }

        @DeleteMapping(value={"/**"}, consumes={"application/vnd.api+json"})
        public ResponseEntity<String> elideDeleteRelationship(@RequestBody String body, HttpServletRequest request, Principal authentication) {
            ElideResponse response = this.elide.delete(ElideControllerAutoConfiguration.getJsonApiPath(request, this.elideProperties.getPrefix()), body, (Object)authentication);
            return ResponseEntity.status((int)response.getResponseCode()).body((Object)response.getBody());
        }

        @DeleteMapping(value={"/**"})
        public ResponseEntity<String> elideDelete(HttpServletRequest request, Principal authentication) {
            ElideResponse response = this.elide.delete(ElideControllerAutoConfiguration.getJsonApiPath(request, this.elideProperties.getPrefix()), null, (Object)authentication);
            return ResponseEntity.status((int)response.getResponseCode()).body((Object)response.getBody());
        }
    }

    @Configuration
    @RestController
    @RequestMapping(value={"${elide.prefix:/api}"}, produces={"application/vnd.api+json"})
    @ConditionalOnProperty(prefix="elide.mvc", value={"patch"}, havingValue="true", matchIfMissing=true)
    public static class ElidePatchController {
        private final Elide elide;
        private final ElideProperties elideProperties;

        @Autowired
        public ElidePatchController(Elide elide, ElideProperties elideProperties) {
            this.elide = elide;
            this.elideProperties = elideProperties;
        }

        @PatchMapping(value={"/**"}, consumes={"application/vnd.api+json"})
        public ResponseEntity<String> elidePatch(@RequestBody String body, HttpServletRequest request, Principal authentication) {
            ElideResponse response = this.elide.patch(ElideControllerAutoConfiguration.JSON_API_CONTENT_TYPE, ElideControllerAutoConfiguration.JSON_API_CONTENT_TYPE, ElideControllerAutoConfiguration.getJsonApiPath(request, this.elideProperties.getPrefix()), body, (Object)authentication);
            return ResponseEntity.status((int)response.getResponseCode()).body((Object)response.getBody());
        }
    }

    @Configuration
    @RestController
    @RequestMapping(value={"${elide.prefix:/api}"}, produces={"application/vnd.api+json"})
    @ConditionalOnProperty(prefix="elide.mvc", value={"post"}, havingValue="true", matchIfMissing=true)
    public static class ElidePostController {
        private final Elide elide;
        private final ElideProperties elideProperties;

        @Autowired
        public ElidePostController(Elide elide, ElideProperties elideProperties) {
            this.elide = elide;
            this.elideProperties = elideProperties;
        }

        @PostMapping(value={"/**"}, consumes={"application/vnd.api+json"})
        public ResponseEntity<String> elidePost(@RequestBody String body, HttpServletRequest request, Principal authentication) {
            ElideResponse response = this.elide.post(ElideControllerAutoConfiguration.getJsonApiPath(request, this.elideProperties.getPrefix()), body, (Object)authentication);
            return ResponseEntity.status((int)response.getResponseCode()).body((Object)response.getBody());
        }
    }

    @Configuration
    @RestController
    @RequestMapping(value={"${elide.prefix:/api}"}, produces={"application/vnd.api+json"})
    @ConditionalOnProperty(prefix="elide.mvc", value={"get"}, havingValue="true", matchIfMissing=true)
    public static class ElideGetController {
        private final Elide elide;
        private final ElideProperties elideProperties;

        @Autowired
        public ElideGetController(Elide elide, ElideProperties elideProperties) {
            this.elide = elide;
            this.elideProperties = elideProperties;
        }

        @GetMapping(value={"/**"})
        public ResponseEntity<String> elideGet(@RequestParam Map<String, String> allRequestParams, HttpServletRequest request, Principal authentication) {
            ElideResponse response = this.elide.get(ElideControllerAutoConfiguration.getJsonApiPath(request, this.elideProperties.getPrefix()), (MultivaluedMap)new MultivaluedHashMap(allRequestParams), (Object)authentication);
            return ResponseEntity.status((int)response.getResponseCode()).body((Object)response.getBody());
        }
    }
}

