/*
 * Decompiled with CFR 0.152.
 */
package org.illyasviel.elide.spring.boot.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideSettingsBuilder;
import com.yahoo.elide.core.DataStore;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.filter.dialect.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.dialect.SubqueryFilterDialect;
import com.yahoo.elide.functions.LifeCycleHook;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.security.checks.Check;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import org.atteo.classindex.ClassIndex;
import org.hibernate.ScrollMode;
import org.illyasviel.elide.spring.boot.annotation.ElideCheck;
import org.illyasviel.elide.spring.boot.annotation.ElideHook;
import org.illyasviel.elide.spring.boot.autoconfigure.ElideProperties;
import org.illyasviel.elide.spring.boot.datastore.SpringHibernateDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableConfigurationProperties(value={ElideProperties.class})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class, WebMvcAutoConfiguration.class})
public class ElideAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ElideAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public Elide elide(PlatformTransactionManager txManager, AutowireCapableBeanFactory beanFactory, ApplicationContext context, EntityManager entityManager, ObjectMapper objectMapper, ElideProperties elideProperties) {
        ConcurrentHashMap<String, Class<? extends Check>> checks = new ConcurrentHashMap<String, Class<? extends Check>>();
        this.scanChecks(checks);
        EntityDictionary entityDictionary = new EntityDictionary(checks);
        RSQLFilterDialect rsqlFilterDialect = new RSQLFilterDialect(entityDictionary);
        SpringHibernateDataStore springDataStore = new SpringHibernateDataStore(txManager, beanFactory, entityManager, elideProperties, true, ScrollMode.FORWARD_ONLY);
        Elide elide = new Elide(new ElideSettingsBuilder((DataStore)springDataStore).withJsonApiMapper(new JsonApiMapper(entityDictionary, objectMapper)).withEntityDictionary(entityDictionary).withJoinFilterDialect((JoinFilterDialect)rsqlFilterDialect).withSubqueryFilterDialect((SubqueryFilterDialect)rsqlFilterDialect).withDefaultPageSize(elideProperties.getDefaultPageSize()).withDefaultMaxPageSize(elideProperties.getMaxPageSize()).withReturnErrorObjects(elideProperties.isReturnErrorObjects()).build());
        this.scanLifeCycleHook(entityDictionary, context);
        return elide;
    }

    private void scanChecks(ConcurrentHashMap<String, Class<? extends Check>> checks) {
        for (Class clazz : ClassIndex.getAnnotated(ElideCheck.class)) {
            ElideCheck elideCheck = clazz.getAnnotation(ElideCheck.class);
            if (Check.class.isAssignableFrom(clazz)) {
                logger.debug("Register Elide Check [{}] with expression [{}]", (Object)clazz.getCanonicalName(), (Object)elideCheck.value());
                checks.put(elideCheck.value(), clazz.asSubclass(Check.class));
                continue;
            }
            throw new RuntimeException("The class[" + clazz.getCanonicalName() + "] being annotated with @ElideCheck must be a Check.");
        }
    }

    private void scanLifeCycleHook(EntityDictionary entityDictionary, ApplicationContext context) {
        for (Class clazz : ClassIndex.getAnnotated(ElideHook.class)) {
            if (LifeCycleHook.class.isAssignableFrom(clazz)) {
                ElideHook elideHook = clazz.getAnnotation(ElideHook.class);
                Class entity = null;
                for (Type genericInterface : clazz.getGenericInterfaces()) {
                    if (!(genericInterface instanceof ParameterizedType) || !((ParameterizedType)genericInterface).getRawType().equals(LifeCycleHook.class)) continue;
                    Type[] genericTypes = ((ParameterizedType)genericInterface).getActualTypeArguments();
                    entity = (Class)genericTypes[0];
                }
                if (entity == null) {
                    throw new RuntimeException("entity is null, this should not be thrown");
                }
                if (elideHook.fieldOrMethodName().equals("")) {
                    entityDictionary.bindTrigger(entity, elideHook.lifeCycle(), (LifeCycleHook)context.getBean(clazz));
                } else {
                    entityDictionary.bindTrigger(entity, elideHook.lifeCycle(), elideHook.fieldOrMethodName(), (LifeCycleHook)context.getBean(clazz));
                }
                logger.debug("Register Elide Function Hook: bindTrigger({}, {}, \"{}\", {})", new Object[]{entity.getCanonicalName(), elideHook.lifeCycle().getSimpleName(), elideHook.fieldOrMethodName(), clazz.getCanonicalName()});
                continue;
            }
            throw new RuntimeException("The class[" + clazz.getCanonicalName() + "] being annotated with @ElideHook must implements LifeCycleHook<T>.");
        }
    }
}

