/*
 * Decompiled with CFR 0.152.
 */
package org.illyasviel.elide.spring.boot.datastore;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.datastores.hibernate5.HibernateTransaction;
import java.io.IOException;
import javax.persistence.PersistenceException;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.hibernate.exception.ConstraintViolationException;
import org.illyasviel.elide.spring.boot.exception.UnprocessableEntityException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public class SpringHibernateTransaction
extends HibernateTransaction {
    private final Session session;
    private final TransactionStatus txStatus;
    private final PlatformTransactionManager txManager;

    protected SpringHibernateTransaction(Session session, PlatformTransactionManager txManager, TransactionStatus txStatus, boolean isScrollEnabled, ScrollMode scrollMode) {
        super(session, isScrollEnabled, scrollMode);
        this.session = session;
        this.txManager = txManager;
        this.txStatus = txStatus;
    }

    public void flush(RequestScope requestScope) {
        try {
            super.flush(requestScope);
        }
        catch (TransactionException e) {
            PersistenceException pe = (PersistenceException)e.getCause();
            if (pe.getCause() instanceof ConstraintViolationException) {
                throw new UnprocessableEntityException("Some fields violate constraint(notnull, unique, ...)", e);
            }
            throw e;
        }
    }

    public void commit(RequestScope scope) {
        try {
            this.flush(scope);
            this.txManager.commit(this.txStatus);
        }
        catch (org.springframework.transaction.TransactionException e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.session.isOpen() && !this.txStatus.isCompleted()) {
            this.txManager.rollback(this.txStatus);
            throw new IOException("Transaction not closed");
        }
    }
}

