/*
 * Decompiled with CFR 0.152.
 */
package org.illyasviel.elide.spring.boot.graphql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.core.DataStoreTransaction;
import com.yahoo.elide.core.ErrorObjects;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.CustomErrorException;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.graphql.GraphQLRequestScope;
import com.yahoo.elide.graphql.ModelBuilder;
import com.yahoo.elide.graphql.PersistentResourceFetcher;
import com.yahoo.elide.security.User;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.DataFetcher;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.lang3.tuple.Pair;
import org.illyasviel.elide.spring.boot.graphql.GraphQLErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLHandle {
    private static final Logger log = LoggerFactory.getLogger(GraphQLHandle.class);
    private Elide elide;
    private ElideSettings elideSettings;
    private GraphQL api;
    private static final String QUERY = "query";
    private static final String OPERATION_NAME = "operationName";
    private static final String VARIABLES = "variables";
    private static final String MUTATION = "mutation";

    public GraphQLHandle(Elide elide) {
        log.info("Elide GraphQL Started ~~");
        this.elide = elide;
        this.elideSettings = elide.getElideSettings();
        PersistentResourceFetcher fetcher = new PersistentResourceFetcher(elide.getElideSettings());
        ModelBuilder builder = new ModelBuilder(elide.getElideSettings().getDictionary(), (DataFetcher)fetcher);
        this.api = new GraphQL(builder.build());
    }

    public ElideResponse post(String graphQLDocument, Object opaqueUser) {
        JsonNode topLevel;
        ObjectMapper mapper = this.elide.getMapper().getObjectMapper();
        try {
            topLevel = mapper.readTree(graphQLDocument);
        }
        catch (IOException e) {
            log.debug("Invalid json body provided to GraphQL", (Throwable)e);
            return this.buildErrorResponse((HttpStatusException)new InvalidEntityBodyException(graphQLDocument), false);
        }
        Function<JsonNode, ElideResponse> executeRequest = node -> this.executeGraphQLRequest(mapper, opaqueUser, graphQLDocument, (JsonNode)node);
        if (topLevel.isArray()) {
            Iterator nodeIterator = topLevel.iterator();
            Iterable nodeIterable = () -> nodeIterator;
            Stream<JsonNode> nodeStream = StreamSupport.stream(nodeIterable.spliterator(), false);
            ArrayNode result = nodeStream.map(executeRequest).map(response -> {
                try {
                    return mapper.readTree(response.getBody());
                }
                catch (IOException e) {
                    log.debug("Caught an IO exception while trying to read response body");
                    return JsonNodeFactory.instance.objectNode();
                }
            }).reduce(JsonNodeFactory.instance.arrayNode(), (arrayNode, node) -> arrayNode.add(node), (left, right) -> left.addAll(right));
            try {
                return new ElideResponse(200, mapper.writeValueAsString((Object)result));
            }
            catch (JsonProcessingException e) {
                log.error("An unexpected error occurred trying to serialize array response.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return executeRequest.apply(topLevel);
    }

    /*
     * Loose catch block
     */
    private ElideResponse executeGraphQLRequest(ObjectMapper mapper, Object opaqueUser, String graphQLDocument, JsonNode jsonDocument) {
        boolean isVerbose = false;
        try {
            ElideResponse elideResponse;
            Object object;
            DataStoreTransaction tx;
            block38: {
                block39: {
                    GraphQLRequestScope requestScope;
                    block35: {
                        ElideResponse elideResponse2;
                        block36: {
                            block37: {
                                tx = this.elide.getDataStore().beginTransaction();
                                object = null;
                                User user = tx.accessUser(opaqueUser);
                                requestScope = new GraphQLRequestScope(tx, user, this.elide.getElideSettings());
                                isVerbose = requestScope.getPermissionExecutor().isVerbose();
                                if (jsonDocument.has(QUERY)) break block35;
                                elideResponse2 = new ElideResponse(400, "A `query` key is required.");
                                if (tx == null) break block36;
                                if (object == null) break block37;
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                break block36;
                            }
                            tx.close();
                        }
                        return elideResponse2;
                    }
                    String query = jsonDocument.get(QUERY).asText();
                    log.info("Processing GraphQL query:\n{}", (Object)query);
                    ExecutionInput.Builder executionInput = new ExecutionInput.Builder().context((Object)requestScope).query(query);
                    if (jsonDocument.has(OPERATION_NAME) && !jsonDocument.get(OPERATION_NAME).isNull()) {
                        executionInput.operationName(jsonDocument.get(OPERATION_NAME).asText());
                    }
                    if (jsonDocument.has(VARIABLES) && !jsonDocument.get(VARIABLES).isNull()) {
                        Map variables = (Map)mapper.convertValue((Object)jsonDocument.get(VARIABLES), Map.class);
                        executionInput.variables(variables);
                    }
                    ExecutionResult result = this.api.execute(executionInput);
                    tx.preCommit();
                    requestScope.runQueuedPreSecurityTriggers();
                    requestScope.getPermissionExecutor().executeCommitChecks();
                    if (query.trim().startsWith(MUTATION)) {
                        if (!result.getErrors().isEmpty()) {
                            HashMap<String, List> abortedResponseObject = new HashMap<String, List>();
                            abortedResponseObject.put("errors", result.getErrors());
                            abortedResponseObject.put("data", null);
                            throw new GraphQLErrorException(200, mapper.writeValueAsString(abortedResponseObject));
                        }
                        requestScope.saveOrCreateObjects();
                    }
                    tx.flush((RequestScope)requestScope);
                    requestScope.runQueuedPreCommitTriggers();
                    this.elide.getAuditLogger().commit((RequestScope)requestScope);
                    tx.commit((RequestScope)requestScope);
                    requestScope.runQueuedPostCommitTriggers();
                    if (log.isTraceEnabled()) {
                        requestScope.getPermissionExecutor().printCheckStats();
                    }
                    elideResponse = new ElideResponse(200, mapper.writeValueAsString((Object)result.toSpecification()));
                    if (tx == null) break block38;
                    if (object == null) break block39;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block38;
                }
                tx.close();
            }
            return elideResponse;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (tx != null) {
                            if (object != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (WebApplicationException e) {
                    log.debug("WebApplicationException", (Throwable)e);
                    throw e;
                }
                catch (GraphQLErrorException e) {
                    log.debug("GraphQLErrorException", (Throwable)e);
                    object = e.getResponse();
                    return object;
                }
                catch (JsonProcessingException e) {
                    log.debug("Invalid json body provided to GraphQL", (Throwable)e);
                    object = this.buildErrorResponse((HttpStatusException)new InvalidEntityBodyException(graphQLDocument), isVerbose);
                    return object;
                }
                catch (IOException e) {
                    log.error("Uncaught IO Exception by Elide in GraphQL", (Throwable)e);
                    object = this.buildErrorResponse((HttpStatusException)((Object)new TransactionException((Throwable)e)), isVerbose);
                    return object;
                }
                catch (HttpStatusException e) {
                    log.debug("Caught HTTP status exception {}", (Object)e.getStatus(), (Object)e);
                    object = this.buildErrorResponse(new HttpStatusException(200, ""){
                        private static final long serialVersionUID = 1L;

                        public int getStatus() {
                            return 200;
                        }

                        public Pair<Integer, JsonNode> getErrorResponse() {
                            return e.getErrorResponse();
                        }

                        public Pair<Integer, JsonNode> getVerboseErrorResponse() {
                            return e.getVerboseErrorResponse();
                        }

                        public String getVerboseMessage() {
                            return e.getVerboseMessage();
                        }

                        public String toString() {
                            return e.toString();
                        }
                    }, isVerbose);
                    return object;
                }
                catch (Error | Exception e) {
                    log.debug("Unhandled error or exception.", e);
                    throw e;
                }
            }
        }
        finally {
            this.elide.getAuditLogger().clear();
        }
    }

    private ElideResponse buildErrorResponse(HttpStatusException error, boolean isVerbose) {
        String errorBody;
        JsonNode errorNode;
        ObjectMapper mapper = this.elide.getMapper().getObjectMapper();
        if (!(error instanceof CustomErrorException) && this.elideSettings.isReturnErrorObjects()) {
            ErrorObjects errors = ErrorObjects.builder().addError().with("message", (Object)(isVerbose ? error.getVerboseMessage() : error.toString())).build();
            errorNode = (JsonNode)mapper.convertValue((Object)errors, JsonNode.class);
        } else {
            errorNode = isVerbose ? (JsonNode)error.getVerboseErrorResponse().getRight() : (JsonNode)error.getErrorResponse().getRight();
        }
        try {
            errorBody = mapper.writeValueAsString((Object)errorNode);
        }
        catch (JsonProcessingException e) {
            errorBody = errorNode.toString();
        }
        return new ElideResponse(error.getStatus(), errorBody);
    }
}

