/*
 * Decompiled with CFR 0.152.
 */
package org.illyasviel.sample.elide.domain;

import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.annotation.OnCreatePreSecurity;
import com.yahoo.elide.annotation.ReadPermission;
import javax.inject.Inject;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.illyasviel.sample.elide.util.PasswordEncoder;

@Table(name="users")
@Entity
@Include(rootLevel=true)
public class User {
    private Integer id;
    private String username;
    private String password;
    private String encodedPassword;
    @Inject
    private PasswordEncoder passwordEncoder;

    @Id
    @GeneratedValue
    public Integer getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    @NotNull
    @ReadPermission(expression="reject all")
    public String getPassword() {
        return this.password;
    }

    public String getEncodedPassword() {
        return this.encodedPassword;
    }

    @OnCreatePreSecurity
    public void onCreatePreSecurity() {
        this.setEncodedPassword(this.passwordEncoder.encode(this.getPassword()));
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEncodedPassword(String encodedPassword) {
        this.encodedPassword = encodedPassword;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }
}

