/*
 * Decompiled with CFR 0.152.
 */
package org.illyasviel.sample.elide.hook;

import com.yahoo.elide.annotation.OnUpdatePreCommit;
import com.yahoo.elide.functions.LifeCycleHook;
import com.yahoo.elide.security.ChangeSpec;
import com.yahoo.elide.security.RequestScope;
import java.util.Optional;
import org.illyasviel.elide.spring.boot.annotation.ElideHook;
import org.illyasviel.sample.elide.domain.User;
import org.illyasviel.sample.elide.util.PasswordEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ElideHook(lifeCycle=OnUpdatePreCommit.class, fieldOrMethodName="password")
public class UserOnUpdatePreCommit
implements LifeCycleHook<User> {
    private static final Logger logger = LoggerFactory.getLogger(UserOnUpdatePreCommit.class);
    private final PasswordEncoder passwordEncoder;

    @Autowired
    public UserOnUpdatePreCommit(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void execute(User user, RequestScope requestScope, Optional<ChangeSpec> changes) {
        logger.info("User: OnUpdatePreCommit(\"password\") function hook execute!");
        user.setEncodedPassword(this.passwordEncoder.encode(user.getPassword()));
    }
}

