/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.security.oidc.marty;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.security.Principal;
import java.util.logging.Logger;
import org.imixs.marty.profile.ProfileEvent;
import org.imixs.security.oidc.OidcContext;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;

@RequestScoped
public class UserProfileHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(UserProfileHandler.class.getName());
    @Inject
    Principal principal;
    @Inject
    private OidcContext context;

    public void onProfileEvent(@Observes ProfileEvent profileEvent) throws AccessDeniedException {
        int eventType = profileEvent.getEventType();
        ItemCollection profile = profileEvent.getProfile();
        if (profile == null) {
            return;
        }
        if (this.context != null && (2 == eventType || 3 == eventType)) {
            String userName = this.context.getUsername();
            String email = this.context.getEmail();
            if (!email.equals(profile.getItemValueString("txtemail")) || !userName.equals(profile.getItemValueString("txtusername"))) {
                logger.info("...update profile data...");
                profile.setItemValue("txtemail", (Object)email);
                profile.setItemValue("txtusername", (Object)userName);
            }
        }
    }
}

