/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.security.oidc;

import com.nimbusds.jose.jwk.RSAKey;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.json.JsonObject;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.security.oidc.OidcConfig;
import org.imixs.security.oidc.OidcContext;
import org.imixs.security.oidc.TokenValidator;
import org.imixs.security.oidc.UserInfoService;

@RequestScoped
public class BearerTokenValidator {
    private static final Logger logger = Logger.getLogger(BearerTokenValidator.class.getName());
    @Inject
    OidcConfig oidcConfig;
    @Inject
    OidcContext oidcContext;
    @Inject
    TokenValidator tokenValidator;
    @Inject
    UserInfoService userInfoService;

    public AuthenticationStatus handle(HttpServletRequest request, HttpMessageContext context) {
        boolean debug = logger.isLoggable(Level.FINE);
        String authHeader = request.getHeader("Authorization");
        if (debug) {
            logger.fine("\u2502   \u251c\u2500\u2500 Authorization header: " + authHeader);
        }
        if (authHeader != null && authHeader.startsWith("Bearer ")) {
            String token = authHeader.substring("Bearer ".length());
            if (debug) {
                logger.info("\u251c\u2500\u2500 Bearer token validation...");
            }
            try {
                JsonObject enrichedClaims;
                String username;
                Map<String, RSAKey> publicKeys = this.oidcConfig.getJwks();
                if (!TokenValidator.isTokenValid(token, publicKeys)) {
                    logger.warning("\u2502   \u251c\u2500\u2500 \u274c invalid JWT-Token (signature/expires)");
                    return context.responseUnauthorized();
                }
                JsonObject tokenClaims = TokenValidator.decodeJwtPayload(token);
                if (debug) {
                    logger.info("\u2502   \u251c\u2500\u2500 token claims=" + String.valueOf(tokenClaims));
                }
                if ((username = TokenValidator.extractUsername(enrichedClaims = this.userInfoService.fetchAndMergeUserInfo(token, tokenClaims), this.oidcConfig.getClaimCallerName())) == null || username.isBlank()) {
                    logger.warning("\u2502   \u251c\u2500\u2500 \u274c no username found in claims.");
                    return context.responseUnauthorized();
                }
                List<String> roles = TokenValidator.extractRoles(enrichedClaims, this.oidcConfig.getClaimRolePath());
                if (debug) {
                    logger.info("\u2502   \u251c\u2500\u2500 username=" + username);
                    if (roles != null && !roles.isEmpty()) {
                        logger.info("\u2502   \u251c\u2500\u2500 roles=" + String.join((CharSequence)", ", roles));
                    } else {
                        logger.warning("\u2502   \u251c\u2500\u2500 unable to resolve roles");
                        logger.warning("\u2502   \u251c\u2500\u2500 claims=" + String.valueOf(enrichedClaims));
                    }
                }
                if (debug) {
                    logger.info("\u251c\u2500\u2500 \u2705 Authorization successful ");
                }
                this.oidcContext.initialize(enrichedClaims);
                return context.notifyContainerAboutLogin(() -> username, new HashSet<String>(roles));
            }
            catch (Exception e) {
                logger.warning("Invalid JWT token: " + e.getMessage());
                return context.responseUnauthorized();
            }
        }
        logger.warning("\u251c\u2500\u2500 no Bearer token found!");
        return context.responseUnauthorized();
    }
}

