/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.security.oidc;

import com.nimbusds.jose.jwk.RSAKey;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.security.oidc.OidcConfig;
import org.imixs.security.oidc.TokenResponse;
import org.imixs.security.oidc.TokenValidator;
import org.imixs.security.oidc.UserInfoService;

@WebServlet(value={"/callback"})
public class CallbackServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger(CallbackServlet.class.getName());
    @Inject
    OidcConfig oidcConfig;
    @Inject
    UserInfoService userInfoService;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean debug = logger.isLoggable(Level.FINE);
        String code = request.getParameter("code");
        if (debug) {
            logger.info("\u251c\u2500\u2500 callback code= " + code);
        }
        if (code == null || code.isEmpty()) {
            response.sendError(400, "Missing authorization code");
            return;
        }
        TokenResponse tokenResponse = this.exchangeAuthorizationCode(code);
        if (tokenResponse == null) {
            response.sendError(500, "Token exchange failed");
            return;
        }
        String idToken = tokenResponse.id_token;
        logger.fine("\u2502   \u251c\u2500\u2500 idToken= " + idToken);
        try {
            JsonObject enrichedClaims;
            String username;
            Map<String, RSAKey> publicKeys = this.oidcConfig.getJwks();
            if (!TokenValidator.isTokenValid(idToken, publicKeys)) {
                response.sendError(401, "Invalid ID token");
                return;
            }
            JsonObject idTokenClaims = TokenValidator.decodeJwtPayload(idToken);
            if (debug) {
                logger.info("\u2502   \u251c\u2500\u2500 ID token claims=" + String.valueOf(idTokenClaims));
            }
            if ((username = TokenValidator.extractUsername(enrichedClaims = this.userInfoService.fetchAndMergeUserInfo(tokenResponse.access_token, idTokenClaims), this.oidcConfig.getClaimCallerName())) == null) {
                throw new NullPointerException("Username resolved to null");
            }
            List<String> roles = TokenValidator.extractRoles(enrichedClaims, this.oidcConfig.getClaimRolePath());
            if (debug) {
                logger.info("\u2502   \u251c\u2500\u2500 username=" + username);
                if (roles != null && !roles.isEmpty()) {
                    logger.info("\u2502   \u251c\u2500\u2500 roles=" + String.join((CharSequence)", ", roles));
                } else {
                    logger.warning("\u2502   \u251c\u2500\u2500 unable to resolve roles");
                    logger.warning("\u2502   \u251c\u2500\u2500 claims=" + String.valueOf(enrichedClaims));
                }
            }
            request.getSession().setAttribute("username", (Object)username);
            request.getSession().setAttribute("access_token", (Object)tokenResponse.access_token);
            request.getSession().setAttribute("roles", roles);
            request.getSession().setAttribute("claims", (Object)enrichedClaims);
            logger.info("\u251c\u2500\u2500 \u2705 OIDC Login successful ");
            HttpSession session = request.getSession();
            String redirectTo = (String)session.getAttribute("originalRequest");
            if (redirectTo != null) {
                session.removeAttribute("originalRequest");
            }
            if (redirectTo != null && !redirectTo.isEmpty()) {
                logger.info("\u251c\u2500\u2500 \u2611\ufe0f redirect to: " + redirectTo);
            }
            response.sendRedirect(redirectTo != null ? redirectTo : "/index.xhtml");
        }
        catch (Exception e) {
            logger.severe("\u251c\u2500\u2500 \u274c OIDC Login error: " + e.getMessage());
            e.printStackTrace();
            response.sendError(500, "Login processing failed");
        }
    }

    private TokenResponse exchangeAuthorizationCode(String code) throws IOException {
        TokenResponse tokenResponse;
        block13: {
            boolean debug = logger.isLoggable(Level.FINE);
            HttpClient client = HttpClient.newHttpClient();
            if (debug) {
                logger.info("\u2502   \u251c\u2500\u2500 exchangeAuthorizationCode=" + code);
            }
            String body = "grant_type=authorization_code&code=" + URLEncoder.encode(code, StandardCharsets.UTF_8) + "&redirect_uri=" + URLEncoder.encode(this.oidcConfig.getRedirectURI(), StandardCharsets.UTF_8) + "&client_id=" + URLEncoder.encode(this.oidcConfig.getClientId(), StandardCharsets.UTF_8) + "&client_secret=" + URLEncoder.encode(this.oidcConfig.getClientSecret(), StandardCharsets.UTF_8);
            if (debug) {
                logger.info("\u2502   \u251c\u2500\u2500 tokenEndpoint=" + this.oidcConfig.getTokenEndpoint());
            }
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.oidcConfig.getTokenEndpoint())).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(body)).build();
            HttpResponse<String> response = client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (debug) {
                logger.info("\u2502   \u251c\u2500\u2500 response statusCode=" + response.statusCode());
            }
            if (response.statusCode() != 200) {
                logger.warning("Token exchange failed with status " + response.statusCode() + ": " + response.body());
                return null;
            }
            JsonReader reader = Json.createReader((Reader)new StringReader(response.body()));
            try {
                JsonObject json = reader.readObject();
                logger.fine("\u2502   \u251c\u2500\u2500 json response= " + String.valueOf(json));
                TokenResponse token = new TokenResponse();
                token.access_token = json.getString("access_token", null);
                token.id_token = json.getString("id_token", null);
                token.refresh_token = json.getString("refresh_token", null);
                token.token_type = json.getString("token_type", null);
                token.scope = json.getString("scope", null);
                long l = token.expires_in = json.getJsonNumber("expires_in") != null ? json.getJsonNumber("expires_in").longValue() : 0L;
                if (debug) {
                    logger.finest("\u2502   \u2502   \u251c\u2500\u2500 access_token= " + token.access_token);
                    logger.finest("\u2502   \u2502   \u251c\u2500\u2500 id_token= " + token.id_token);
                    logger.finest("\u2502   \u2502   \u251c\u2500\u2500 refresh_token= " + token.refresh_token);
                    logger.finest("\u2502   \u2502   \u251c\u2500\u2500 token_type= " + token.token_type);
                    logger.info("\u2502   \u2502   \u251c\u2500\u2500 scope= " + token.scope);
                    logger.info("\u2502   \u2502   \u251c\u2500\u2500 expires_in= " + token.expires_in);
                }
                tokenResponse = token;
                if (reader == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InterruptedException e) {
                    logger.severe("Error during token exchange: " + e.getMessage());
                    e.printStackTrace();
                    return null;
                }
            }
            reader.close();
        }
        return tokenResponse;
    }
}

