/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.security.oidc;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.json.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.io.Serializable;
import java.security.Principal;
import java.util.logging.Logger;
import org.imixs.security.oidc.OidcContext;

@RequestScoped
@Path(value="/oidc-debug")
@Produces(value={"text/plain"})
public class OidcApi
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(OidcApi.class.getName());
    @Inject
    Principal principal;
    @Inject
    private OidcContext context;

    @GET
    @Produces(value={"text/plain"})
    public String sessionInfoAuth(@Context HttpServletRequest request) {
        StringBuilder output = new StringBuilder();
        try {
            String msg;
            output.append("\n=== Imixs-OIDC - Debug Information ===\n");
            if (this.principal != null) {
                output.append("Principal: ").append(this.principal.getName()).append("\n");
            } else {
                msg = "Warning: Principal resolved to null!";
                output.append(msg).append("\n");
            }
            if (this.context == null) {
                msg = "Error: Failed to resolve OpenIdContext!";
                logger.severe(msg);
                return msg;
            }
            output.append("\nOIDC Claim:\n").append("===============================\n").append("").append(this.formatJsonObject(this.context.getClaims())).append("\n").append("===============================\n");
            logger.info(output.toString());
            return output.toString();
        }
        catch (Exception e) {
            String error = "Failed to resolve OpenIdContext: " + e.getMessage();
            logger.severe(error);
            return error;
        }
    }

    private String formatJsonObject(JsonObject json) {
        if (json == null) {
            return "null";
        }
        return json.toString().replaceAll(",", ",\n    ");
    }
}

