/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.security.oidc;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.security.oidc.OidcConfig;

@RequestScoped
public class OidcAuthFlowHandler {
    private static Logger logger = Logger.getLogger(OidcAuthFlowHandler.class.getName());
    @Inject
    OidcConfig oidcConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationStatus handle(HttpServletRequest request, HttpServletResponse response, HttpMessageContext context) throws IOException {
        HttpSession session;
        if (request.getRequestURI().contains("/callback")) {
            return context.doNothing();
        }
        boolean debug = logger.isLoggable(Level.FINE);
        Object originalRequest = request.getRequestURI();
        String query = request.getQueryString();
        if (query != null && !query.isEmpty()) {
            originalRequest = (String)originalRequest + "?" + query;
        }
        HttpSession httpSession = session = request.getSession(true);
        synchronized (httpSession) {
            session.setAttribute("originalRequest", originalRequest);
        }
        String providerAuthEndpoint = this.oidcConfig.getAuthorizationEndpoint();
        if (debug) {
            logger.info("\u251c\u2500\u2500 starting OIDC Auth Flow...");
            logger.info("\u2502   \u251c\u2500\u2500 providerAuthEndpoint=" + providerAuthEndpoint);
            logger.info("\u2502   \u251c\u2500\u2500 client_id=" + this.oidcConfig.getClientId());
            logger.info("\u2502   \u251c\u2500\u2500 redirect_uri=" + this.oidcConfig.getRedirectURI());
            logger.info("\u2502   \u251c\u2500\u2500 scope=" + this.oidcConfig.getScope());
        }
        String loginUrl = providerAuthEndpoint + "?response_type=code&client_id=" + URLEncoder.encode(this.oidcConfig.getClientId(), StandardCharsets.UTF_8) + "&redirect_uri=" + URLEncoder.encode(this.oidcConfig.getRedirectURI(), StandardCharsets.UTF_8) + "&scope=" + URLEncoder.encode(this.oidcConfig.getScope(), StandardCharsets.UTF_8);
        response.sendRedirect(loginUrl);
        return AuthenticationStatus.SEND_CONTINUE;
    }
}

