/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.security.oidc;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.json.JsonObject;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.security.oidc.BearerTokenValidator;
import org.imixs.security.oidc.OidcAuthFlowHandler;
import org.imixs.security.oidc.OidcConfig;
import org.imixs.security.oidc.OidcContext;

@ApplicationScoped
public class OidcAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static Logger logger = Logger.getLogger(OidcAuthenticationMechanism.class.getName());
    @Inject
    BearerTokenValidator bearerTokenValidator;
    @Inject
    OidcAuthFlowHandler oidcAuthFlowHandler;
    @Inject
    OidcConfig oidcConfig;
    @Inject
    OidcContext oidcContext;

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext context) throws AuthenticationException {
        try {
            boolean debug = logger.isLoggable(Level.FINE);
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null && authHeader.startsWith("Bearer ")) {
                if (debug) {
                    logger.info("\u251c\u2500\u2500 \ud83e\udeb2 initiating ROPC login flow (Bearer token detected)");
                }
                return this.bearerTokenValidator.handle(request, context);
            }
            String path = request.getRequestURI();
            if (path.startsWith("/callback")) {
                if (debug) {
                    logger.info("\u2502   \u251c\u2500\u2500 callback request");
                }
                return context.doNothing();
            }
            HttpSession session = request.getSession(false);
            if (session != null && session.getAttribute("username") != null) {
                String username = (String)session.getAttribute("username");
                List roles = (List)session.getAttribute("roles");
                logger.finest("\u2502   \u251c\u2500\u2500 session user found: " + username);
                this.oidcContext.initialize((JsonObject)session.getAttribute("claims"));
                return context.notifyContainerAboutLogin(() -> username, new HashSet(roles));
            }
            if (!context.isProtected()) {
                return context.doNothing();
            }
            if (debug) {
                logger.info("\u251c\u2500\u2500 \ud83e\udeb2 initiating OIDC login flow");
            }
            return this.oidcAuthFlowHandler.handle(request, response, context);
        }
        catch (IOException e) {
            throw new AuthenticationException("Error handling authentication", (Throwable)e);
        }
    }
}

