/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.security.oidc;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
@Named
public class OidcConfig
implements Serializable {
    private static final long serialVersionUID = 7027147503119012594L;
    private static final Logger logger = Logger.getLogger(OidcConfig.class.getName());
    private static final long JWKS_REFRESH_INTERVAL_SECONDS = 600L;
    @Inject
    @ConfigProperty(name="OIDCCONFIG_PROVIDERURI", defaultValue="http://localhost/")
    String providerURI;
    @Inject
    @ConfigProperty(name="OIDCCONFIG_CLIENTID", defaultValue="undefined")
    String clientId;
    @Inject
    @ConfigProperty(name="OIDCCONFIG_CLIENTSECRET", defaultValue="undefined")
    String clientSecret;
    @Inject
    @ConfigProperty(name="OIDCCONFIG_REDIRECTURI", defaultValue="undefined")
    String redirectURI;
    @Inject
    @ConfigProperty(name="OIDCCONFIG_SCOPE", defaultValue="openid profile email")
    String scope;
    @Inject
    @ConfigProperty(name="OIDCCONFIG_CLAIM_CALLERNAME", defaultValue="preferred_username")
    Optional<String> claimCallerName;
    @Inject
    @ConfigProperty(name="OIDCCONFIG_CLAIM_ROLES")
    Optional<String> claimRolePath;
    @Inject
    @ConfigProperty(name="OIDCCONFIG_ENABLE_USERINFO", defaultValue="false")
    boolean enableUserInfo;
    private JsonObject config;
    private Map<String, RSAKey> cachedJwks;
    private long lastFetchTimestamp = 0L;

    @PostConstruct
    public void init() {
        this.config = this.fetchConfig(this.providerURI);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getProviderURI() {
        return this.providerURI;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public String getClaimCallerName() {
        if (this.claimCallerName.isPresent()) {
            return this.claimCallerName.get();
        }
        return null;
    }

    public String getClaimRolePath() {
        if (this.claimRolePath.isPresent()) {
            return this.claimRolePath.get();
        }
        return null;
    }

    public String getScope() {
        return this.scope.replace(",", "");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private JsonObject fetchConfig(String issuerUri) {
        try {
            Object discoveryUrl = issuerUri;
            if (!((String)discoveryUrl).endsWith(".well-known/openid-configuration")) {
                if (!issuerUri.endsWith("/")) {
                    discoveryUrl = (String)discoveryUrl + "/";
                }
                discoveryUrl = (String)discoveryUrl + ".well-known/openid-configuration";
            }
            logger.info("\u251c\u2500\u2500 Fetching OIDC config from: " + (String)discoveryUrl);
            try (InputStream is = new URL((String)discoveryUrl).openStream();){
                JsonObject jsonObject;
                block16: {
                    JsonReader reader = Json.createReader((InputStream)is);
                    try {
                        jsonObject = reader.readObject();
                        if (reader == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                return jsonObject;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load OIDC configuration from " + issuerUri, e);
        }
    }

    public String getAuthorizationEndpoint() {
        return this.config.getString("authorization_endpoint", null);
    }

    public String getTokenEndpoint() {
        return this.config.getString("token_endpoint", null);
    }

    public String getJwksUri() {
        return this.config.getString("jwks_uri", null);
    }

    public String getUserinfoEndpoint() {
        return this.config.getString("userinfo_endpoint", null);
    }

    public String getIssuer() {
        return this.config.getString("issuer", null);
    }

    public JsonObject getRawConfig() {
        return this.config;
    }

    public String getProviderUri() {
        return this.providerURI;
    }

    public boolean isUserInfoEnabled() {
        return this.enableUserInfo;
    }

    public synchronized Map<String, RSAKey> getJwks() throws Exception {
        long now = System.currentTimeMillis() / 1000L;
        boolean debug = logger.isLoggable(Level.FINE);
        if (this.cachedJwks == null || now - this.lastFetchTimestamp > 600L) {
            if (debug) {
                logger.info("\u251c\u2500\u2500 \u23f3 JWKS cache expired or missing. Fetching from provider...");
            }
            try {
                Map<String, RSAKey> newJwks = this.fetchJwksRemote();
                this.cachedJwks = newJwks;
                this.lastFetchTimestamp = now;
            }
            catch (Exception e) {
                if (this.cachedJwks != null) {
                    logger.warning("JWKS refresh failed, using cached version: " + e.getMessage());
                    return this.cachedJwks;
                }
                throw e;
            }
        } else {
            logger.fine("\u251c\u2500\u2500 \u2705 Using cached JWKS.");
        }
        return this.cachedJwks;
    }

    private Map<String, RSAKey> fetchJwksRemote() throws Exception {
        boolean debug = logger.isLoggable(Level.FINE);
        String jwksUri = this.getJwksUri();
        if (debug) {
            logger.info("\u251c\u2500\u2500 \ud83d\udce5 Fetching JWKS from: " + jwksUri);
        }
        try (InputStream is = new URL(jwksUri).openStream();){
            JWKSet jwkSet = JWKSet.load((InputStream)is);
            Map<String, RSAKey> map = jwkSet.getKeys().stream().filter(k -> k instanceof RSAKey).map(k -> (RSAKey)k).collect(Collectors.toMap(JWK::getKeyID, k -> k));
            return map;
        }
    }
}

