/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.security.oidc;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.RSAKey;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class TokenValidator {
    private static final Logger logger = Logger.getLogger(TokenValidator.class.getName());

    public static JsonObject decodeJwtPayload(String jwt) throws Exception {
        String[] parts = jwt.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid JWT token format");
        }
        String payloadJson = new String(Base64.getUrlDecoder().decode(parts[1]));
        try (JsonReader reader = Json.createReader((Reader)new StringReader(payloadJson));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    public static boolean isTokenValid(String jwt, Map<String, RSAKey> publicKeys) {
        try {
            long exp;
            JWSObject jwsObject = JWSObject.parse((String)jwt);
            JWSHeader header = jwsObject.getHeader();
            if (publicKeys != null) {
                String kid = header.getKeyID();
                RSAKey rsaKey = publicKeys.get(kid);
                if (rsaKey == null) {
                    logger.warning("\u251c\u2500\u2500 \u274c no key found for kid=" + kid);
                    return false;
                }
                boolean valid = jwsObject.verify((JWSVerifier)new RSASSAVerifier(rsaKey.toRSAPublicKey()));
                if (!valid) {
                    logger.warning("\u251c\u2500\u2500 \u274c signature verification failed.");
                    return false;
                }
            }
            JsonObject claims = TokenValidator.decodeJwtPayload(jwt);
            long now = System.currentTimeMillis() / 1000L;
            if (claims.containsKey((Object)"exp") && now > (exp = claims.getJsonNumber("exp").longValue())) {
                logger.warning("\u251c\u2500\u2500 \u274c token expired!");
                return false;
            }
            logger.fine("\u251c\u2500\u2500 \u2705 token successful verified.");
            return true;
        }
        catch (Exception e) {
            logger.severe("\u251c\u2500\u2500 \u274c error validating token: " + e.getMessage());
            return false;
        }
    }

    public static String extractUsername(JsonObject claims, String claimCallerName) {
        if (claimCallerName == null || claimCallerName.isBlank()) {
            if (claims.containsKey((Object)"preferred_username")) {
                return claims.getString("preferred_username");
            }
            if (claims.containsKey((Object)"sub")) {
                return claims.getString("sub");
            }
            return claims.getString("name");
        }
        try {
            return claims.getString(claimCallerName);
        }
        catch (NullPointerException e) {
            logger.severe("\u251c\u2500\u2500 \u274c error failed to resolve '" + claimCallerName + "' from claim!");
            return null;
        }
    }

    public static List<String> extractRoles(JsonObject claims, String claimPath) {
        if (claimPath == null || claimPath.isBlank()) {
            List<String> result = TokenValidator.extractFromPath(claims, "roles");
            if (!result.isEmpty()) {
                return result;
            }
            result = TokenValidator.extractFromPath(claims, "groups");
            if (!result.isEmpty()) {
                return result;
            }
            result = TokenValidator.extractFromPath(claims, "realm_access.roles");
            return result;
        }
        return TokenValidator.extractFromPath(claims, claimPath);
    }

    private static List<String> extractFromPath(JsonObject claims, String path) {
        if (path.contains(".")) {
            String[] pathParts = path.split("\\.");
            JsonObject current = claims;
            for (String part : pathParts) {
                JsonObject obj;
                if (!(current instanceof JsonObject) || !(obj = current).containsKey((Object)part)) {
                    return List.of();
                }
                current = (JsonValue)obj.get((Object)part);
            }
            return TokenValidator.extractArrayAsStringList((JsonValue)current);
        }
        if (claims.containsKey((Object)path)) {
            return TokenValidator.extractArrayAsStringList((JsonValue)claims.get((Object)path));
        }
        return List.of();
    }

    private static List<String> extractArrayAsStringList(JsonValue value) {
        if (value == null) {
            return List.of();
        }
        if (value instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            return array.getValuesAs(v -> v.toString().replace("\"", ""));
        }
        return List.of();
    }
}

