/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.security.oidc;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.security.oidc.OidcConfig;

@RequestScoped
public class UserInfoService {
    private static final Logger logger = Logger.getLogger(UserInfoService.class.getName());
    @Inject
    OidcConfig oidcConfig;

    public JsonObject fetchAndMergeUserInfo(String accessToken, JsonObject idTokenClaims) {
        if (!this.oidcConfig.isUserInfoEnabled()) {
            return idTokenClaims;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        String userInfoEndpoint = this.oidcConfig.getUserinfoEndpoint();
        if (userInfoEndpoint == null || userInfoEndpoint.isEmpty()) {
            if (debug) {
                logger.fine("\u2502   \u251c\u2500\u2500 No UserInfo endpoint configured, using ID token claims only");
            }
            return idTokenClaims;
        }
        if (accessToken == null || accessToken.isEmpty()) {
            logger.warning("\u2502   \u251c\u2500\u2500 No access token available for UserInfo request");
            return idTokenClaims;
        }
        try {
            JsonObject userInfo;
            if (debug) {
                logger.info("\u2502   \u251c\u2500\u2500 Fetching UserInfo from: " + userInfoEndpoint);
            }
            if ((userInfo = this.fetchUserInfo(accessToken, userInfoEndpoint)) != null) {
                return this.mergeClaimsWithUserInfo(idTokenClaims, userInfo);
            }
            logger.warning("\u2502   \u251c\u2500\u2500 UserInfo request failed, using ID token claims only");
            return idTokenClaims;
        }
        catch (Exception e) {
            logger.warning("\u2502   \u251c\u2500\u2500 Error fetching UserInfo: " + e.getMessage());
            return idTokenClaims;
        }
    }

    private JsonObject fetchUserInfo(String accessToken, String userInfoEndpoint) throws IOException, InterruptedException {
        HttpRequest request;
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(userInfoEndpoint)).header("Authorization", "Bearer " + accessToken).header("Accept", "application/json").GET().build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            try (JsonReader reader = Json.createReader((Reader)new StringReader(response.body()));){
                JsonObject userInfo = reader.readObject();
                logger.fine("\u2502   \u251c\u2500\u2500 UserInfo response: " + String.valueOf(userInfo));
                JsonObject jsonObject = userInfo;
                return jsonObject;
            }
        }
        logger.warning("\u2502   \u251c\u2500\u2500 UserInfo request failed with status: " + response.statusCode());
        logger.warning("\u2502   \u251c\u2500\u2500 Response body: " + response.body());
        return null;
    }

    private JsonObject mergeClaimsWithUserInfo(JsonObject idTokenClaims, JsonObject userInfo) {
        JsonObjectBuilder mergedBuilder = Json.createObjectBuilder();
        idTokenClaims.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)mergedBuilder).add(arg_0, arg_1));
        userInfo.forEach((key, value) -> mergedBuilder.add(key, value));
        JsonObject merged = mergedBuilder.build();
        logger.fine("\u2502   \u251c\u2500\u2500 Merged claims: " + String.valueOf(merged));
        return merged;
    }
}

