/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.lucene.LuceneSearchService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class DatevImportService {
    public static final String DATEN_FEHLER = "DATEN_FEHLER";
    public static final String IMPORT_ERROR = "IMPORT_ERROR";
    public static final int MAX_SEARCH_RESULT = 100;
    @EJB
    DocumentService documentService;
    private static Logger logger = Logger.getLogger(DatevImportService.class.getName());

    public ItemCollection findEntityByName(String key, String type, String clientID) {
        String searchTerm = "(type:\"" + type + "\" AND txtname:\"" + key + "\"";
        if (clientID != null && !clientID.isEmpty()) {
            searchTerm = searchTerm + " AND _datev_client_id:\"" + clientID + "\"";
        }
        searchTerm = searchTerm + ")";
        try {
            List col = this.documentService.find(searchTerm, 1, 0);
            if (col.size() > 0) {
                return (ItemCollection)col.iterator().next();
            }
        }
        catch (QueryException e) {
            logger.warning(e.getMessage());
        }
        return null;
    }

    public List<ItemCollection> searchEntity(String phrase, String type, String clientID) {
        ArrayList<ItemCollection> searchResult = new ArrayList<ItemCollection>();
        if (phrase == null || phrase.isEmpty()) {
            return searchResult;
        }
        Collection col = null;
        try {
            phrase = phrase.trim();
            phrase = LuceneSearchService.normalizeSearchTerm((String)phrase);
            String sQuery = "(type:\"" + type + "\"";
            if (clientID != null && !clientID.isEmpty()) {
                sQuery = sQuery + " AND _datev_client_id:\"" + clientID + "\"";
            }
            sQuery = sQuery + ")";
            sQuery = sQuery + " AND (" + phrase + "*)";
            logger.finest("searchprofile: " + sQuery);
            logger.fine("searchWorkitems: " + sQuery);
            col = this.documentService.find(sQuery, 100, 0);
        }
        catch (Exception e) {
            logger.warning("  lucene error - " + e.getMessage());
        }
        for (ItemCollection kreditor : col) {
            searchResult.add(kreditor);
        }
        Collections.sort(searchResult, new ItemCollectionComparator("txtname", true));
        return searchResult;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String importData(InputStream imputStream, String encoding) throws PluginException {
        String type = null;
        String clientID = null;
        String consultenID = null;
        logger.info("...starting csv data import...");
        String log = "";
        int line = 0;
        String dataLine = null;
        ArrayList<String> idCache = new ArrayList<String>();
        int workitemsTotal = 0;
        int workitemsImported = 0;
        int workitemsUpdated = 0;
        int workitemsDeleted = 0;
        int workitemsFailed = 0;
        int blockSize = 0;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(imputStream, encoding));
            String header1 = in.readLine();
            String[] header1List = header1.split(";(?=([^\"]*\"[^\"]*\")*[^\"]*$)", 99);
            header1List = this.normalizeValueList(header1List);
            if (header1List == null || header1List.length < 4) {
                throw new PluginException(this.getClass().getName(), IMPORT_ERROR, "File Format not supported, 1st line must contain the fromatname in column 4 (type).");
            }
            type = header1List[3];
            if (type == null || type.isEmpty()) {
                throw new PluginException(this.getClass().getName(), IMPORT_ERROR, "File Format not supported, 1st line must contain the fromatname (type).");
            }
            clientID = header1List[11];
            consultenID = header1List[12];
            if (clientID == null || clientID.isEmpty() || consultenID == null || consultenID.isEmpty()) {
                throw new PluginException(this.getClass().getName(), IMPORT_ERROR, "File Format not supported, 1st line must contain the Mandant and Berater ID.");
            }
            type = type.trim().toLowerCase();
            logger.info("...object type=" + type);
            ++line;
            String fieldnames = in.readLine();
            ++line;
            List<String> fields = this.parseFieldList(fieldnames);
            String keyField = fields.get(0).trim();
            while ((dataLine = in.readLine()) != null) {
                ++blockSize;
                ++line;
                ++workitemsTotal;
                ItemCollection entity = this.readEntity(dataLine, fields);
                entity.replaceItemValue("_datev_client_id", (Object)clientID);
                entity.replaceItemValue("_datev_consultant_id", (Object)consultenID);
                entity.replaceItemValue("txtname", (Object)entity.getItemValue(keyField));
                idCache.add(entity.getItemValueString("txtname"));
                ItemCollection oldEntity = this.findEntityByName(entity.getItemValueString("txtName"), type, clientID);
                if (oldEntity == null) {
                    this.saveEntry(entity, type, clientID, consultenID);
                    ++workitemsImported;
                } else if (!this.isEqualEntity(oldEntity, entity, fields)) {
                    logger.fine("update exsting entity: " + oldEntity.getUniqueID());
                    oldEntity.replaceAllItems(entity.getAllItems());
                    this.saveEntry(oldEntity, type, clientID, consultenID);
                    ++workitemsUpdated;
                }
                if (blockSize < 100) continue;
                blockSize = 0;
                logger.info(workitemsTotal + " entries read....");
            }
            logger.info("completed: " + workitemsTotal + " entries successful read");
        }
        catch (Exception e) {
            ++workitemsFailed;
            String sError = "import error at line " + line + ": " + e + " Datensatz=" + dataLine;
            logger.severe(sError);
            throw new PluginException(DatevImportService.class.getName(), DATEN_FEHLER, sError, e);
        }
        finally {
            try {
                if (imputStream != null) {
                    imputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            List entries;
            logger.info("removing deprecated entries...");
            String sQuery = "(type:\"" + type + "\"";
            if (clientID != null && !clientID.isEmpty()) {
                sQuery = sQuery + " AND _datev_client_id:\"" + clientID + "\"";
            }
            if ((entries = this.documentService.find(sQuery = sQuery + ")", 999, 0)) != null && entries.size() > 0) {
                for (ItemCollection entity : entries) {
                    String id = entity.getItemValueString("txtname");
                    if (idCache.contains(id)) continue;
                    this.documentService.remove(entity);
                    ++workitemsDeleted;
                }
            }
        }
        catch (QueryException e) {
            String sError = "import error: unable to delete data";
            logger.severe(sError);
            throw new PluginException(DatevImportService.class.getName(), DATEN_FEHLER, sError, (Exception)((Object)e));
        }
        log = log + workitemsTotal + " entries read \n" + workitemsImported + " new entries \n" + workitemsUpdated + " updates \n" + workitemsDeleted + " deletions \n" + workitemsFailed + " errors";
        logger.info(log);
        return log;
    }

    public String[] normalizeValueList(String[] data) {
        for (int i = 0; i < data.length; ++i) {
            String value = data[i];
            if (!value.startsWith("\"") || !value.endsWith("\"")) continue;
            data[i] = value = value.substring(1, value.length() - 1);
        }
        return data;
    }

    public List<String> parseFieldList(String data) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(data, ";");
        while (st.hasMoreTokens()) {
            String field = st.nextToken().trim();
            if (!field.isEmpty()) {
                field = field.replace(".", "");
                field = field.replace(' ', '_');
                field = field.replace('/', '_');
                field = field.replace('\\', '_');
                field = field.replace('.', '_');
                field = field.replace('>', '_');
                field = field.replace('<', '_');
                field = field.replace('&', '_');
                result.add("_" + field.trim());
                continue;
            }
            result.add(null);
        }
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void saveEntry(ItemCollection aWorkitem, String type, String clientID, String consultenID) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        aWorkitem.replaceItemValue("type", (Object)type);
        aWorkitem.replaceItemValue("_datev_client_id", (Object)clientID);
        aWorkitem.replaceItemValue("_datev_consultant_id", (Object)consultenID);
        this.documentService.save(aWorkitem);
    }

    public ItemCollection readEntity(String data, List<String> fieldnames) {
        ItemCollection result = new ItemCollection();
        int iCol = 0;
        String[] valuList = data.split(";(?=([^\"]*\"[^\"]*\")*[^\"]*$)", 99);
        for (String itemValue : valuList = this.normalizeValueList(valuList)) {
            if ((itemValue = itemValue.trim()) != null && !itemValue.isEmpty()) {
                result.replaceItemValue(fieldnames.get(iCol), (Object)itemValue);
            } else {
                result.replaceItemValue(fieldnames.get(iCol), (Object)"");
            }
            if (++iCol >= fieldnames.size()) break;
        }
        return result;
    }

    private boolean isEqualEntity(ItemCollection oldEntity, ItemCollection entity, List<String> fields) {
        if (!entity.getItemValue("_datev_client_id").equals(oldEntity.getItemValue("_datev_client_id"))) {
            return false;
        }
        if (!entity.getItemValue("_datev_consultant_id").equals(oldEntity.getItemValue("_datev_consultant_id"))) {
            return false;
        }
        for (String itemName : fields) {
            if (entity.getItemValue(itemName).equals(oldEntity.getItemValue(itemName))) continue;
            return false;
        }
        return true;
    }
}

