/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.services;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.datev.services.DatevException;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.exceptions.WorkflowException;
import org.imixs.workflow.util.XMLParser;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@LocalBean
public class DatevWorkflowService {
    public static final String DATEV_CONFIGURATION = "DATEV_CONFIGURATION";
    public static final int EVENT_START = 100;
    public static final int EVENT_SUCCESS = 200;
    public static final int EVENT_FAILED = 300;
    public static final String INVOICE_UPDATE = "invoice_update";
    public static final String LINK_PROPERTY = "$workitemref";
    public static final String ITEM_MODEL_VERSION = "_model_version";
    public static final String ITEM_INITIAL_TASK = "_initial_task";
    public static final String ITEM_DATEV_CLIENT_ID = "_datev_client_id";
    public static final String ITEM_DATEV_CONSULTANT_ID = "_datev_consultant_id";
    public static final String ITEM_DATEV_FISCAL_START = "_datev_fiscal_start";
    public static final String REPORT_ERROR = "REPORT_ERROR";
    public static final String MODEL_ERROR = "MODEL_ERROR";
    public static final String PROCESSING_ERROR = "PROCESSING_ERROR";
    public static final String CONFIG_ERROR = "CONFIG_ERROR";
    public static final String IO_ERROR = "IO_ERROR";
    public static final String FILE_NOT_FOUND = "FILE_NOT_FOUND";
    public static final String ISO8601_FORMAT_DATETIME = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String ISO8601_FORMAT_DATE = "yyyy-MM-dd";
    public static final String TYPE = "datev";
    @EJB
    WorkflowService workflowService = null;
    private static Logger logger = Logger.getLogger(DatevWorkflowService.class.getName());

    @PostConstruct
    public void init() {
    }

    public List<ItemCollection> findAllConfigurations() {
        List col = this.workflowService.getDocumentService().getDocumentsByType(TYPE);
        Collections.sort(col, new ItemCollectionComparator("txtname", true));
        return col;
    }

    public ItemCollection loadConfiguration(String id) {
        if (id == null || id.isEmpty()) {
            logger.warning("invalid shop configuration id=" + id);
        }
        ItemCollection configItemCollection = null;
        String searchTerm = "( (type:\"datev\" ) AND txtname:\"" + id + "\")";
        try {
            List col = this.workflowService.getDocumentService().find(searchTerm, 1, 0);
            if (col.size() > 0) {
                configItemCollection = (ItemCollection)col.iterator().next();
                logger.fine("datev configuration id=" + id + " loaded");
            } else {
                logger.warning("datev configuration id=" + id + " not defined!");
            }
        }
        catch (QueryException e) {
            logger.warning(e.getMessage());
        }
        return configItemCollection;
    }

    public ItemCollection findWorkitemByName(String sKey) {
        String searchTerm = "( (type:\"workitem\" OR type:\"workitemarchive\") AND txtname:\"" + sKey + "\")";
        try {
            List col = this.workflowService.getDocumentService().find(searchTerm, 1, 0);
            if (col.size() > 0) {
                return (ItemCollection)col.iterator().next();
            }
        }
        catch (QueryException e) {
            logger.warning(e.getMessage());
        }
        return null;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ItemCollection importEntities(ItemCollection configuration, int start, int maxcount) throws DatevException {
        List vtime;
        int line = 0;
        String datevLine = null;
        String modelversion = null;
        String filename = null;
        String encoding = null;
        Long lastImport = null;
        long modifiedTime = 0L;
        int workitemsImported = 0;
        int workitemsUpdated = 0;
        int workitemsFailed = 0;
        int workitemsTotal = 0;
        String sDatevID = configuration.getItemValueString("txtName");
        String sDatevPrimaryKey = configuration.getItemValueString("_datev_primarykey");
        filename = configuration.getItemValueString("_datev_path");
        logger.info("DATEV import id= " + sDatevID + " : " + filename);
        modelversion = configuration.getItemValueString("_datev_modelversion");
        encoding = configuration.getItemValueString("_datev_encoding");
        if (encoding.isEmpty()) {
            encoding = "UTF-8";
        }
        if ((vtime = configuration.getItemValue("_datev_lLastImport")).size() == 0) {
            lastImport = new Long(0L);
        } else {
            try {
                lastImport = (Long)vtime.get(0);
            }
            catch (ClassCastException e) {
                lastImport = new Long(0L);
            }
        }
        int processID = Integer.parseInt(configuration.getItemValueString("_datev_processid"));
        int activityID = Integer.parseInt(configuration.getItemValueString("_datev_activityid"));
        if (modelversion.isEmpty() || processID == 0 || activityID == 0) {
            logger.severe("Invalid Model Information: " + modelversion + " " + processID + "." + activityID + " - Verify DATEV configuration " + sDatevID);
            throw new DatevException(MODEL_ERROR, MODEL_ERROR, "Invalid Model Information");
        }
        File file = new File(filename);
        modifiedTime = file.lastModified();
        if (modifiedTime == 0L) {
            throw new DatevException(sDatevID, FILE_NOT_FOUND, "Datev importfile '" + filename + "' not found!");
        }
        if (lastImport < modifiedTime) {
            DataInputStream in = null;
            try {
                FileInputStream fis = new FileInputStream(filename);
                in = new DataInputStream(fis);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, encoding));
                br.readLine();
                ++line;
                String fieldnames = br.readLine();
                ++line;
                List<String> fields = this.parseFieldList(fieldnames);
                if (start > 0) {
                    for (int i = 0; i < start && br.readLine() != null; ++i) {
                    }
                }
                while ((datevLine = br.readLine()) != null) {
                    ++line;
                    ++workitemsTotal;
                    ItemCollection entity = this.readEntity(datevLine, fields);
                    entity.replaceItemValue("txtname", (Object)entity.getItemValue("_datev_" + sDatevPrimaryKey));
                    ItemCollection oldEntity = this.findWorkitemByName(entity.getItemValueString("txtName"));
                    if (oldEntity == null) {
                        entity.setModelVersion(modelversion);
                        entity.setTaskID(processID);
                        entity.setEventID(activityID);
                        this.processSingleWorkitem(entity);
                        ++workitemsImported;
                        continue;
                    }
                    if (this.isEqualEntity(oldEntity, entity)) continue;
                    logger.fine("update exsting DATV entity: " + oldEntity.getUniqueID());
                    oldEntity.replaceAllItems(entity.getAllItems());
                    oldEntity.setEventID(activityID);
                    this.processSingleWorkitem(oldEntity);
                    ++workitemsUpdated;
                }
                configuration.replaceItemValue("_datev_lLastImport", (Object)modifiedTime);
                configuration.replaceItemValue("_datev_datLastImport", (Object)new Date(modifiedTime));
            }
            catch (IOException ioex) {
                throw new DatevException(DatevWorkflowService.class.getName(), IO_ERROR, "" + ioex, ioex);
            }
            catch (Exception e) {
                ++workitemsFailed;
                logger.severe("DATEV import error at line " + line + ": " + datevLine);
                if (e.getCause() instanceof InvalidAccessException) {
                    throw new DatevException(DatevWorkflowService.class.getName(), ((InvalidAccessException)e.getCause()).getErrorCode(), ((InvalidAccessException)e.getCause()).getMessage(), e);
                }
                if (e.getCause() instanceof WorkflowException) {
                    throw new DatevException(DatevWorkflowService.class.getName(), ((WorkflowException)e.getCause()).getErrorCode(), ((WorkflowException)e.getCause()).getMessage(), e);
                }
                throw new DatevException(DatevWorkflowService.class.getName(), PROCESSING_ERROR, "" + e, e);
            }
            finally {
                configuration.replaceItemValue("numWorkItemsImported", (Object)workitemsImported);
                configuration.replaceItemValue("numWorkItemsUpdated", (Object)workitemsUpdated);
                configuration.replaceItemValue("numWorkItemsFailed", (Object)workitemsFailed);
                configuration.replaceItemValue("numWorkitemsTotal", (Object)workitemsTotal);
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return configuration;
    }

    private boolean isEqualEntity(ItemCollection oldEntity, ItemCollection entity) {
        Set fields = entity.getAllItems().keySet();
        for (String itemName : fields) {
            if (entity.getItemValue(itemName).equals(oldEntity.getItemValue(itemName))) continue;
            return false;
        }
        return true;
    }

    public List<String> parseFieldList(String data) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(data, ";");
        while (st.hasMoreTokens()) {
            String field = st.nextToken();
            if (!field.isEmpty()) {
                field = field.replace(' ', '_');
                field = field.replace('/', '_');
                field = field.replace('\\', '_');
                field = field.replace('.', '_');
                field = field.replace('>', '_');
                field = field.replace('<', '_');
                field = field.replace('&', '_');
                result.add(field);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public ItemCollection readEntity(String data, List<String> fieldnames) {
        String[] valuList;
        ItemCollection result = new ItemCollection();
        int iCol = 0;
        for (String itemValue : valuList = data.split(";(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -1)) {
            if (itemValue != null && !itemValue.isEmpty()) {
                Date dateValue = this.parseISODate(itemValue);
                if (dateValue != null) {
                    result.replaceItemValue("_datev_" + fieldnames.get(iCol), (Object)dateValue);
                } else {
                    result.replaceItemValue("_datev_" + fieldnames.get(iCol), (Object)itemValue);
                }
            } else {
                result.replaceItemValue("_datev_" + fieldnames.get(iCol), (Object)"");
            }
            ++iCol;
        }
        return result;
    }

    private Date parseISODate(String itemValue) {
        Date date;
        SimpleDateFormat format2;
        try {
            format2 = new SimpleDateFormat(ISO8601_FORMAT_DATETIME);
            date = format2.parse(itemValue);
            if (date != null) {
                return date;
            }
        }
        catch (Exception format2) {
            // empty catch block
        }
        try {
            format2 = new SimpleDateFormat(ISO8601_FORMAT_DATE);
            date = format2.parse(itemValue);
            if (date != null) {
                return date;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void processSingleWorkitem(ItemCollection aWorkitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        this.workflowService.processWorkItem(aWorkitem);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void processInvoices(ItemCollection datevExport, List<ItemCollection> invoices, ItemCollection event, ItemCollection configuration) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        List subProcessDefinitions = null;
        ItemCollection evalItemCollection = this.workflowService.evalWorkflowResult(event, datevExport, false);
        subProcessDefinitions = evalItemCollection.getItemValue(INVOICE_UPDATE);
        if (subProcessDefinitions == null || subProcessDefinitions.size() == 0) {
            return;
        }
        for (String processValue : subProcessDefinitions) {
            ItemCollection processData;
            if (processValue.trim().isEmpty() || (processData = XMLParser.parseItemStructure((String)processValue)) == null) continue;
            String model_pattern = processData.getItemValueString("modelversion");
            String process_pattern = processData.getItemValueString("task");
            for (ItemCollection _invoice : invoices) {
                ItemCollection invoice = this.workflowService.getWorkItem(_invoice.getUniqueID());
                if (invoice == null) continue;
                String subModelVersion = invoice.getModelVersion();
                String subProcessID = "" + invoice.getTaskID();
                if (!Pattern.compile(model_pattern).matcher(subModelVersion).find() || !Pattern.compile(process_pattern).matcher(subProcessID).find()) continue;
                logger.finest("...... subprocess matches criteria.");
                if (processData.hasItem("items")) {
                    logger.warning("subprocess itemList is not supported by the DatevScheduler!");
                }
                try {
                    invoice.setEventID(Integer.valueOf(processData.getItemValueString("event")).intValue());
                }
                catch (NumberFormatException e) {
                    throw new ModelException("INVALID_MODEL_ENTRY", "unable to parse event '" + processData.getItemValueString("event") + "'. Please check your model definition '" + invoice.getModelVersion() + "'!", (Exception)e);
                }
                this.workflowService.processWorkItem(invoice);
                DatevWorkflowService.logMessage("...invoice " + _invoice.getUniqueID() + " processed.", configuration, null);
            }
        }
        DatevWorkflowService.logMessage("..." + invoices.size() + " invoices exported. ", configuration, datevExport);
        datevExport.event(100).event(200);
        this.workflowService.processWorkItem(datevExport);
    }

    public static void logMessage(String message, ItemCollection configuration, ItemCollection workitem) {
        if (configuration != null) {
            configuration.appendItemValue("_scheduler_logmessage", (Object)message);
        }
        if (workitem != null) {
            workitem.appendItemValue("_scheduler_logmessage", (Object)message);
        }
        logger.info(message);
    }
}

