/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ejb.EJB;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.datev.services.DatevWorkflowService;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.scheduler.Scheduler;
import org.imixs.workflow.engine.scheduler.SchedulerException;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XSLHandler;

public class DatevSchedulerXML
implements Scheduler {
    public static final int MAX_COUNT = 999;
    @EJB
    DocumentService documentService;
    @EJB
    WorkflowService workflowService;
    @EJB
    DatevWorkflowService datevWorkflowService;
    @EJB
    ModelService modelService;
    @EJB
    ReportService reportService;
    private static Logger logger = Logger.getLogger(DatevSchedulerXML.class.getName());

    public ItemCollection run(ItemCollection configuration) throws SchedulerException {
        ItemCollection invoiceReport = null;
        ItemCollection documentsReport = null;
        String reportNameInvoices = "";
        String reportNameDocuments = "";
        ItemCollection datevExport = null;
        int maxCount = configuration.getItemValueInteger("_maxcount");
        if (maxCount == 0) {
            maxCount = -1;
        }
        try {
            String modelVersion = configuration.getItemValueString("_model_version");
            int taskID = configuration.getItemValueInteger("_initial_task");
            Model model = this.modelService.getModel(modelVersion);
            ItemCollection event = model.getEvent(taskID, 100);
            reportNameInvoices = configuration.getItemValueString("_report_invoices");
            invoiceReport = this.reportService.findReport(reportNameInvoices);
            if (invoiceReport == null) {
                throw new SchedulerException("REPORT_ERROR", "unable to load invoice report definition '" + reportNameInvoices + "'. Please check the configuration");
            }
            reportNameDocuments = configuration.getItemValueString("_report_documents");
            documentsReport = this.reportService.findReport(reportNameDocuments);
            if (documentsReport == null) {
                throw new SchedulerException("REPORT_ERROR", "unable to load documents report definition '" + reportNameDocuments + "'. Please check the configuration");
            }
            List masterDataSet = this.reportService.getDataSource(invoiceReport, 999, 0, "$created", false, null);
            DatevWorkflowService.logMessage("...DATEV xml export started....", configuration, null);
            DatevWorkflowService.logMessage("...found " + masterDataSet.size() + " invoices...", configuration, null);
            if (masterDataSet.size() > 0) {
                for (ItemCollection invoice : masterDataSet) {
                    if (!invoice.getItemValueString("_datev_client_id").isEmpty()) continue;
                    invoice.replaceItemValue("_datev_client_id", (Object)configuration.getItemValue("_datev_client_id"));
                }
                Map<String, List<ItemCollection>> invoiceGroups = this.groupInvoicesBy(masterDataSet, "_datev_client_id");
                for (String key : invoiceGroups.keySet()) {
                    List<ItemCollection> data = invoiceGroups.get(key);
                    datevExport = this.buildZipFile(data, configuration, invoiceReport, documentsReport);
                    this.datevWorkflowService.processInvoices(datevExport, data, event, configuration);
                    DatevWorkflowService.logMessage("...DATEV export ClientID=" + key + "  finished.", configuration, datevExport);
                }
            } else {
                logger.finest("......no invoices found.");
                return configuration;
            }
            DatevWorkflowService.logMessage("...DATEV export completed", configuration, null);
        }
        catch (PluginException e) {
            try {
                if (datevExport != null) {
                    DatevWorkflowService.logMessage("Failed: " + e.getMessage(), configuration, datevExport);
                    datevExport.event(300);
                    this.workflowService.processWorkItem(datevExport);
                }
            }
            catch (AccessDeniedException | ModelException | PluginException | ProcessingErrorException e1) {
                throw new SchedulerException("REPORT_ERROR", "Failed to execute DATEV report '" + reportNameInvoices + "' : " + e.getMessage(), (Exception)((Object)e));
            }
        }
        catch (AccessDeniedException | ModelException | ProcessingErrorException | QueryException e) {
            try {
                if (datevExport != null) {
                    DatevWorkflowService.logMessage("Failed: " + e.getMessage(), configuration, datevExport);
                    datevExport.event(300);
                    this.workflowService.processWorkItem(datevExport);
                }
            }
            catch (Exception e1) {
                throw new SchedulerException("REPORT_ERROR", "Failed to execute DATEV report '" + reportNameInvoices + "' : " + e.getMessage(), (Exception)e);
            }
            throw new SchedulerException("REPORT_ERROR", "Failed to execute DATEV report '" + reportNameInvoices + "' : " + e.getMessage(), (Exception)e);
        }
        return configuration;
    }

    private Map<String, List<ItemCollection>> groupInvoicesBy(List<ItemCollection> datasource, String keyItem) {
        HashMap<String, List<ItemCollection>> result = new HashMap<String, List<ItemCollection>>();
        logger.info("......grouping invoices by '" + keyItem + "'");
        for (ItemCollection invoice : datasource) {
            String key = invoice.getItemValueString(keyItem);
            logger.info("......building invoice group for '" + key + "'");
            ArrayList<ItemCollection> group = (ArrayList<ItemCollection>)result.get(key);
            if (group == null) {
                group = new ArrayList<ItemCollection>();
            }
            group.add(invoice);
            result.put(key, group);
        }
        return result;
    }

    private ItemCollection buildZipFile(List<ItemCollection> data, ItemCollection configuration, ItemCollection invoiceReport, ItemCollection documentsReport) throws SchedulerException {
        ZipOutputStream datevZip = null;
        ByteArrayOutputStream zipOutputStream = null;
        String modelVersion = configuration.getItemValueString("_model_version");
        int taskID = configuration.getItemValueInteger("_initial_task");
        ItemCollection datevExport = new ItemCollection().model(modelVersion).task(taskID);
        datevExport.replaceItemValue("$created", (Object)new Date());
        datevExport.replaceItemValue("$modified", (Object)new Date());
        datevExport.setItemValue("$uniqueid", (Object)WorkflowKernel.generateUniqueID());
        ItemCollection firstInvoice = data.get(0);
        if (firstInvoice.hasItem("_datev_fiscal_start")) {
            datevExport.setItemValue("_datev_fiscal_start", (Object)firstInvoice.getItemValue("_datev_fiscal_start"));
            datevExport.setItemValue("_datev_client_id", (Object)firstInvoice.getItemValue("_datev_client_id"));
        }
        datevExport.setItemValue("_datev_consultant_id", (Object)configuration.getItemValue("_datev_consultant_id"));
        DatevWorkflowService.logMessage("...build new DATEV export...", configuration, datevExport);
        try {
            zipOutputStream = new ByteArrayOutputStream();
            datevZip = new ZipOutputStream(zipOutputStream);
            String xslInvoice = invoiceReport.getItemValueString("XSL").trim();
            if (xslInvoice.isEmpty()) {
                throw new SchedulerException("REPORT_ERROR", "Failed to build DATEV zip archive '" + invoiceReport.getItemValueString("txtname") + " XSL content is missing.");
            }
            String xslDocuments = documentsReport.getItemValueString("XSL").trim();
            if (xslDocuments.isEmpty()) {
                throw new SchedulerException("REPORT_ERROR", "Failed to build DATEV zip archive '" + documentsReport.getItemValueString("txtname") + " XSL content is missing.");
            }
            String encoding = invoiceReport.getItemValueString("encoding");
            for (ItemCollection invoice : data) {
                datevExport.appendItemValue("$workitemref", (Object)invoice.getUniqueID());
                ByteArrayOutputStream outputStream = null;
                try {
                    byte[] xmlData = XMLDataCollectionAdapter.writeItemCollection((ItemCollection)invoice);
                    outputStream = new ByteArrayOutputStream();
                    String xml = new String(xmlData);
                    XSLHandler.transform((String)new String(xml), (String)xslInvoice, (String)encoding, (OutputStream)outputStream);
                    byte[] byteData = outputStream.toByteArray();
                    datevZip.putNextEntry(new ZipEntry(invoice.getUniqueID() + ".xml"));
                    datevZip.write(byteData);
                    datevZip.closeEntry();
                }
                catch (IOException | JAXBException | TransformerException e) {
                    throw new SchedulerException("REPORT_ERROR", "Failed to build DATEV zip archive '" + invoiceReport.getItemValueString("txtname") + "' : " + e.getMessage(), (Exception)e);
                }
                FileData fileData = this.getWorkItemFile(invoice);
                if (fileData != null) {
                    datevZip.putNextEntry(new ZipEntry(fileData.getName()));
                    datevZip.write(fileData.getContent());
                    datevZip.closeEntry();
                }
                DatevWorkflowService.logMessage("......Invoice: " + invoice.getUniqueID() + " added. ", configuration, datevExport);
            }
            ByteArrayOutputStream outputStream = null;
            try {
                byte[] xmlData = XMLDataCollectionAdapter.writeItemCollection(data);
                outputStream = new ByteArrayOutputStream();
                String xml = new String(xmlData);
                XSLHandler.transform((String)new String(xml), (String)xslDocuments, (String)encoding, (OutputStream)outputStream);
                byte[] byteData = outputStream.toByteArray();
                datevZip.putNextEntry(new ZipEntry("document.xml"));
                datevZip.write(byteData);
                datevZip.closeEntry();
            }
            catch (IOException | JAXBException | TransformerException e) {
                throw new SchedulerException("REPORT_ERROR", "Failed to build DATEV zip archive '" + documentsReport.getItemValueString("txtname") + "' : " + e.getMessage(), (Exception)e);
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HHmm");
            String datevFileName = "datev_buchungsstapel_" + df.format(new Date()) + ".zip";
            datevZip.close();
            FileData zipFileData = new FileData(datevFileName, zipOutputStream.toByteArray(), "application/zip", null);
            datevExport.addFileData(zipFileData);
        }
        catch (IOException e) {
            throw new SchedulerException("REPORT_ERROR", "Failed to create DATEV archive '" + invoiceReport.getItemValueString("txtname") + "' : " + e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (datevZip != null) {
                    datevZip.close();
                }
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (IOException e) {
                throw new SchedulerException("REPORT_ERROR", "Failed to close DATEV archive '" + invoiceReport.getItemValueString("txtname") + "' : " + e.getMessage(), (Exception)e);
            }
        }
        return datevExport;
    }

    private FileData getWorkItemFile(ItemCollection invoice) {
        List filenames = invoice.getFileNames();
        if (filenames != null && filenames.size() > 0) {
            String file = (String)filenames.get(0);
            String snapshotID = invoice.getItemValueString("$snapshotid");
            ItemCollection snapshot = this.documentService.load(snapshotID);
            if (snapshot != null) {
                return snapshot.getFileData(file);
            }
        }
        return null;
    }
}

