/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.ejb.EJB;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.datev.services.DatevWorkflowService;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.scheduler.Scheduler;
import org.imixs.workflow.engine.scheduler.SchedulerException;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.util.XMLParser;

public class DatevSchedulerCSV
implements Scheduler {
    public static final int MAX_COUNT = 999;
    @EJB
    DocumentService documentService;
    @EJB
    WorkflowService workflowService;
    @EJB
    ModelService modelService;
    @EJB
    ReportService reportService;
    private static Logger logger = Logger.getLogger(DatevSchedulerCSV.class.getName());

    public ItemCollection run(ItemCollection configuration) throws SchedulerException {
        block22: {
            ByteArrayOutputStream outputStream = null;
            String reportName = "";
            ItemCollection datevExport = null;
            int maxCount = configuration.getItemValueInteger("_maxcount");
            if (maxCount == 0) {
                maxCount = -1;
            }
            try {
                String modelVersion = configuration.getItemValueString("_model_version");
                int taskID = configuration.getItemValueInteger("_initial_task");
                Model model = this.modelService.getModel(modelVersion);
                ItemCollection event = model.getEvent(taskID, 100);
                ItemCollection task = model.getTask(taskID);
                reportName = configuration.getItemValueString("_report_invoices");
                ItemCollection report = this.reportService.findReport(reportName);
                if (report == null) {
                    throw new SchedulerException("REPORT_ERROR", "unable to load report '" + reportName + "'. Please check  model configuration");
                }
                List masterDataSet = this.reportService.getDataSource(report, 999, 0, "$created", false, null);
                DatevWorkflowService.logMessage("...DATEV csv export started....", configuration, null);
                DatevWorkflowService.logMessage("...found " + masterDataSet.size() + " invoices...", configuration, null);
                if (masterDataSet.size() > 0) {
                    for (Object invoice : masterDataSet) {
                        if (!invoice.getItemValueString("_datev_client_id").isEmpty()) continue;
                        invoice.replaceItemValue("_datev_client_id", (Object)configuration.getItemValue("_datev_client_id"));
                    }
                    Map<String, List<ItemCollection>> invoiceGroups = this.groupInvoicesBy(masterDataSet, "_datev_client_id");
                    for (String key : invoiceGroups.keySet()) {
                        List<ItemCollection> data = invoiceGroups.get(key);
                        int groupCount = data.size();
                        datevExport = new ItemCollection().model(modelVersion).task(taskID);
                        datevExport.replaceItemValue("$created", (Object)new Date());
                        datevExport.replaceItemValue("$modified", (Object)new Date());
                        datevExport.setItemValue("$uniqueid", (Object)WorkflowKernel.generateUniqueID());
                        datevExport.setItemValue("_datev_client_id", (Object)key);
                        ItemCollection firstInvoice = data.get(0);
                        if (firstInvoice.hasItem("_datev_fiscal_start")) {
                            datevExport.setItemValue("_datev_fiscal_start", (Object)firstInvoice.getItemValue("_datev_fiscal_start"));
                        }
                        datevExport.setItemValue("_datev_consultant_id", (Object)configuration.getItemValue("_datev_consultant_id"));
                        datevExport.setItemValue("$workflowgroup", (Object)task.getItemValue("txtworkflowgroup"));
                        DatevWorkflowService.logMessage("...starting DATEV export for ClientID=" + key + "...", configuration, datevExport);
                        for (ItemCollection invoice : data) {
                            datevExport.appendItemValue("$workitemref", (Object)invoice.getUniqueID());
                            DatevWorkflowService.logMessage("......Invoice: " + invoice.getUniqueID() + " added. ", configuration, datevExport);
                        }
                        data.add(datevExport);
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HHmm");
                        String datevFileName = "EXTF_Buchungsstapel_" + df.format(new Date()) + ".csv";
                        FileData filedata = this.reportService.transformDataSource(report, data, datevFileName);
                        datevExport.addFileData(filedata);
                        this.processInvoices(datevExport, data, event, configuration);
                        DatevWorkflowService.logMessage("...DATEV export ClientID=" + key + "  finished.", configuration, datevExport);
                        DatevWorkflowService.logMessage("..." + groupCount + " invoices exported. ", configuration, datevExport);
                        datevExport.event(100).event(200);
                        this.workflowService.processWorkItem(datevExport);
                    }
                    DatevWorkflowService.logMessage("...DATEV export completed", configuration, null);
                    break block22;
                }
                logger.finest("......no invoices found.");
                ItemCollection itemCollection = configuration;
                return itemCollection;
            }
            catch (IOException | JAXBException | TransformerException | AccessDeniedException | ModelException | PluginException | ProcessingErrorException | QueryException e) {
                try {
                    if (datevExport != null) {
                        DatevWorkflowService.logMessage("Failed: " + e.getMessage(), configuration, datevExport);
                        datevExport.event(300);
                        this.workflowService.processWorkItem(datevExport);
                    }
                }
                catch (AccessDeniedException | ModelException | PluginException | ProcessingErrorException e1) {
                    throw new SchedulerException("REPORT_ERROR", "Failed to execute DATEV report '" + reportName + "' : " + e.getMessage(), (Exception)e);
                }
                throw new SchedulerException("REPORT_ERROR", "Failed to execute DATEV report '" + reportName + "' : " + e.getMessage(), (Exception)e);
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        throw new SchedulerException("REPORT_ERROR", "Failed to execute DATEV report '" + reportName + "' : " + e.getMessage(), (Exception)e);
                    }
                }
            }
        }
        return configuration;
    }

    private Map<String, List<ItemCollection>> groupInvoicesBy(List<ItemCollection> datasource, String keyItem) {
        HashMap<String, List<ItemCollection>> result = new HashMap<String, List<ItemCollection>>();
        logger.info("......grouping invoices by '" + keyItem + "'");
        for (ItemCollection invoice : datasource) {
            String key = invoice.getItemValueString(keyItem);
            logger.info("......building invoice group for '" + key + "'");
            ArrayList<ItemCollection> group = (ArrayList<ItemCollection>)result.get(key);
            if (group == null) {
                group = new ArrayList<ItemCollection>();
            }
            group.add(invoice);
            result.put(key, group);
        }
        return result;
    }

    protected void processInvoices(ItemCollection datevExport, List<ItemCollection> invoices, ItemCollection event, ItemCollection configuration) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        List subProcessDefinitions = null;
        ItemCollection evalItemCollection = this.workflowService.evalWorkflowResult(event, datevExport, false);
        subProcessDefinitions = evalItemCollection.getItemValue("invoice_update");
        if (subProcessDefinitions == null || subProcessDefinitions.size() == 0) {
            return;
        }
        for (String processValue : subProcessDefinitions) {
            ItemCollection processData;
            if (processValue.trim().isEmpty() || (processData = XMLParser.parseItemStructure((String)processValue)) == null) continue;
            String model_pattern = processData.getItemValueString("modelversion");
            String process_pattern = processData.getItemValueString("task");
            for (ItemCollection _invoice : invoices) {
                ItemCollection invoice = this.workflowService.getWorkItem(_invoice.getUniqueID());
                if (invoice == null) continue;
                String subModelVersion = invoice.getModelVersion();
                String subProcessID = "" + invoice.getTaskID();
                if (!Pattern.compile(model_pattern).matcher(subModelVersion).find() || !Pattern.compile(process_pattern).matcher(subProcessID).find()) continue;
                logger.finest("...... subprocess matches criteria.");
                if (processData.hasItem("items")) {
                    logger.warning("subprocess itemList is not supported by the DatevScheduler!");
                }
                try {
                    invoice.setEventID(Integer.valueOf(processData.getItemValueString("event")).intValue());
                }
                catch (NumberFormatException e) {
                    throw new ModelException("INVALID_MODEL_ENTRY", "unable to parse event '" + processData.getItemValueString("event") + "'. Please check your model definition '" + invoice.getModelVersion() + "'!", (Exception)e);
                }
                invoice = this.workflowService.processWorkItem(invoice);
                DatevWorkflowService.logMessage("...invoice " + _invoice.getUniqueID() + " processed.", configuration, null);
            }
        }
    }
}

