/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.export;

import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.datev.export.DatevExportService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

public class DatevRemoveAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(DatevRemoveAdapter.class.getName());
    public static final String ERROR_MISSING_DATA = "MISSING_DATA";
    public static final String ERROR_CONFIG = "CONFIG_ERROR";
    public static final String ITEM_DATEV_CLIENT_ID = "_datev_client_id";
    public static final String ITEM_DATEV_BOOKING_PERIOD = "_datev_booking_period";
    public static final String ITEM_DBTR_NAME = "_dbtr_name";
    public static final String CHILD_ITEM_PROPERTY = "_ChildItems";
    @Inject
    DatevExportService kriegerDatevService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException, PluginException {
        this.removeInvoice(document);
        return document;
    }

    private void removeInvoice(ItemCollection invoice) throws PluginException {
        String datevClientID = invoice.getItemValueString(ITEM_DATEV_CLIENT_ID);
        if (datevClientID == null || datevClientID.isEmpty()) {
            throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "Datev Export kann nicht korrigiert werden da keine DATEV Client ID definiert wurde. Bitte pr\u00fcfen Sie die Corporate Konfiguration.");
        }
        Date datInvoice = invoice.getItemValueDate("_invoicedate");
        if (datInvoice == null) {
            throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "Datev Export kann nicht erzeugt werden da kein Buchungsdatum angegeben wurde.");
        }
        String key = this.kriegerDatevService.computeKey(invoice);
        logger.info("......Update DATEV export for: '" + key + "'...");
        try {
            List refList;
            ItemCollection datevExport = this.kriegerDatevService.findDatevExport(key);
            if (datevExport != null && (refList = datevExport.getItemValue("$workitemref")).contains(invoice.getUniqueID())) {
                refList.remove(invoice.getUniqueID());
                datevExport.setItemValue("$workitemref", (Object)refList);
                datevExport.event(100);
                this.kriegerDatevService.processDatevExport(datevExport);
            }
        }
        catch (AccessDeniedException | ModelException | ProcessingErrorException | QueryException e1) {
            throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "Es konnte kein DATEV Export zugewiesen werden: " + e1.getMessage());
        }
    }
}

