/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.datev.DatevHelper;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.scheduler.SchedulerException;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XSLHandler;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@LocalBean
public class DatevExportService {
    public static final String ITEM_DATEV_KONTENLAENGE = "_datev_sachkontennummernlaenge";
    public static final String ITEM_FTP_HOST = "_datev_ftp_host";
    public static final String ITEM_FTP_PORT = "_datev_ftp_port";
    public static final String ITEM_FTP_USER = "_datev_ftp_userid";
    public static final String ITEM_FTP_PASSWORD = "_datev_ftp_password";
    public static final String ITEM_FTP_PATH_UPLOAD = "_datev_ftp_path_upload";
    public static final String ITEM_FTP_ERROR = "_ftp_error";
    public static final String ITEM_DATEV_CLIENT_ID = "_datev_client_id";
    public static final String ITEM_DATEV_BOOKING_PERIOD = "_datev_booking_period";
    public static final String ITEM_DATEV_CONSULTANT_ID = "_datev_consultant_id";
    public static final String ITEM_DATEV_FISCAL_START = "_datev_fiscal_start";
    public static final String ITEM_DBTR_NAME = "_dbtr_name";
    public static final String CHILD_ITEM_PROPERTY = "_ChildItems";
    public static final String REPORT_ERROR = "REPORT_ERROR";
    public static final String MODEL_ERROR = "MODEL_ERROR";
    @Inject
    WorkflowService workflowService;
    @Inject
    DocumentService documentService;
    @Inject
    ReportService reportService;
    private static Logger logger = Logger.getLogger(DatevExportService.class.getName());

    public ItemCollection updateExportWorkitem(ItemCollection datevExport, ItemCollection configuration, List<ItemCollection> data) {
        ItemCollection firstInvoice;
        if (data != null && data.size() > 0 && (firstInvoice = data.get(0)).hasItem(ITEM_DATEV_FISCAL_START)) {
            datevExport.setItemValue(ITEM_DATEV_FISCAL_START, (Object)firstInvoice.getItemValue(ITEM_DATEV_FISCAL_START));
            datevExport.setItemValue(ITEM_DATEV_CLIENT_ID, (Object)firstInvoice.getItemValue(ITEM_DATEV_CLIENT_ID));
            datevExport.setItemValue(ITEM_DATEV_KONTENLAENGE, (Object)firstInvoice.getItemValue(ITEM_DATEV_KONTENLAENGE));
            datevExport.setItemValue(ITEM_DATEV_CONSULTANT_ID, (Object)firstInvoice.getItemValue(ITEM_DATEV_CONSULTANT_ID));
        }
        if (datevExport.getItemValueString(ITEM_DATEV_CONSULTANT_ID).isEmpty()) {
            datevExport.setItemValue(ITEM_DATEV_CONSULTANT_ID, (Object)configuration.getItemValue(ITEM_DATEV_CONSULTANT_ID));
        }
        return datevExport;
    }

    public void buildDocumentsZipFile(ItemCollection datevExport, List<ItemCollection> data, String key, ItemCollection configuration) throws SchedulerException, PluginException {
        int documentCount = 0;
        ZipOutputStream datevZip = null;
        ByteArrayOutputStream zipOutputStream = null;
        DatevHelper.logMessage("... Document export started (ClientID=" + datevExport.getItemValueString(ITEM_DATEV_CLIENT_ID) + ") ...", configuration, datevExport);
        String reportNameDocuments = configuration.getItemValueString("_report_documents");
        ItemCollection documentsReport = this.reportService.findReport(reportNameDocuments);
        if (documentsReport == null) {
            throw new SchedulerException(REPORT_ERROR, "unable to load documents report definition '" + reportNameDocuments + "'. Please check the configuration");
        }
        try {
            zipOutputStream = new ByteArrayOutputStream();
            datevZip = new ZipOutputStream(zipOutputStream);
            String xslDocuments = documentsReport.getItemValueString("XSL").trim();
            if (xslDocuments.isEmpty()) {
                throw new SchedulerException(REPORT_ERROR, "Failed to build DATEV zip archive '" + documentsReport.getItemValueString("txtname") + " XSL content is missing.");
            }
            String encoding = documentsReport.getItemValueString("encoding");
            for (ItemCollection exportDataEntity : data) {
                FileData fileData = this.getWorkItemFileFromWorkitem(exportDataEntity);
                if (fileData == null) continue;
                exportDataEntity.removeFile(fileData.getName());
                fileData.setName(exportDataEntity.getUniqueID() + ".pdf");
                try {
                    datevZip.putNextEntry(new ZipEntry(fileData.getName()));
                    datevZip.write(fileData.getContent());
                    datevZip.closeEntry();
                    ++documentCount;
                    DatevHelper.logMessage("......." + fileData.getName() + " added. ", configuration, datevExport);
                }
                catch (ZipException ezip) {
                    DatevHelper.logMessage(".......WARNING : " + ezip.getClass().getSimpleName() + " -> " + ezip.getMessage(), configuration, datevExport);
                }
                Object empty = new byte[0];
                fileData.setContent((byte[])empty);
                exportDataEntity.addFileData(fileData);
            }
            ByteArrayOutputStream outputStream = null;
            try {
                ArrayList<ItemCollection> uniqueDataSource = new ArrayList<ItemCollection>();
                ArrayList<String> idList = new ArrayList<String>();
                for (ItemCollection inovice : data) {
                    if (idList.contains(inovice.getUniqueID())) continue;
                    uniqueDataSource.add(inovice);
                    idList.add(inovice.getUniqueID());
                }
                byte[] xmlData = XMLDataCollectionAdapter.writeItemCollection(uniqueDataSource);
                outputStream = new ByteArrayOutputStream();
                String xml = new String(xmlData);
                XSLHandler.transform((String)new String(xml), (String)xslDocuments, (String)encoding, (OutputStream)outputStream);
                byte[] byteData = outputStream.toByteArray();
                datevZip.putNextEntry(new ZipEntry("document.xml"));
                datevZip.write(byteData);
                datevZip.closeEntry();
            }
            catch (IOException | JAXBException | TransformerException e) {
                throw new SchedulerException(REPORT_ERROR, "Failed to build DATEV zip archive '" + documentsReport.getItemValueString("txtname") + "' : " + e.getMessage(), (Exception)e);
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HHmm");
            String datevFileName = "datev_documents_" + key + "_" + df.format(new Date()) + ".zip";
            datevZip.finish();
            datevZip.close();
            zipOutputStream.close();
            FileData zipFileData = new FileData(datevFileName, zipOutputStream.toByteArray(), "application/zip", null);
            datevExport.addFileData(zipFileData);
        }
        catch (IOException e) {
            throw new SchedulerException(REPORT_ERROR, "Failed to create Documents archive '" + documentsReport.getItemValueString("txtname") + "' : " + e.getClass().getName() + " -> " + e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (datevZip != null) {
                    datevZip.close();
                }
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (IOException e) {
                throw new SchedulerException(REPORT_ERROR, "Failed to close DATEV archive '" + documentsReport.getItemValueString("txtname") + "' : " + e.getMessage(), (Exception)e);
            }
        }
        DatevHelper.logMessage("... Document export completed (ClientID=" + datevExport.getItemValueString(ITEM_DATEV_CLIENT_ID) + ", " + documentCount + " documents)", configuration, datevExport);
    }

    public void buildCSVFile(ItemCollection datevExport, List<ItemCollection> data, String key, ItemCollection configuration) throws SchedulerException {
        FileData filedata;
        String clientID = datevExport.getItemValueString(ITEM_DATEV_CLIENT_ID);
        DatevHelper.logMessage("... CSV export started (ClientID=" + clientID + ") ...", configuration, datevExport);
        String reportNameInvoices = configuration.getItemValueString("_report_invoices");
        ItemCollection invoiceReport = null;
        invoiceReport = this.reportService.findReport(reportNameInvoices + "_" + clientID);
        if (invoiceReport == null) {
            invoiceReport = this.reportService.findReport(reportNameInvoices);
        }
        if (invoiceReport == null) {
            throw new SchedulerException(REPORT_ERROR, "unable to load invoice report definition '" + reportNameInvoices + "'. Please check the configuration");
        }
        LocalDateTime stapelZeitraumStart = null;
        LocalDateTime stapelZeitraumEnde = null;
        for (ItemCollection invoice : data) {
            Date baseDate = invoice.getItemValueDate("_accountingdate");
            if (baseDate == null) {
                baseDate = invoice.getItemValueDate("_invoicedate");
            }
            LocalDateTime invoiceDate = new Date(baseDate.getTime()).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (stapelZeitraumStart == null || stapelZeitraumStart.isAfter(invoiceDate)) {
                stapelZeitraumStart = invoiceDate;
            }
            if (stapelZeitraumEnde != null && !invoiceDate.isAfter(stapelZeitraumEnde)) continue;
            stapelZeitraumEnde = invoiceDate;
        }
        if (stapelZeitraumStart != null) {
            datevExport.replaceItemValue("_stapelzeitraum_start", (Object)Date.from(stapelZeitraumStart.atZone(ZoneId.systemDefault()).toInstant()));
            datevExport.replaceItemValue("_stapelzeitraum_ende", (Object)Date.from(stapelZeitraumEnde.atZone(ZoneId.systemDefault()).toInstant()));
        }
        ArrayList<ItemCollection> tmp_data = new ArrayList<ItemCollection>();
        tmp_data.addAll(data);
        tmp_data.add(datevExport);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HHmm");
        String datevFileName = "EXTF_Buchungsstapel_" + key + "_" + df.format(new Date()) + ".csv";
        try {
            filedata = this.reportService.transformDataSource(invoiceReport, tmp_data, datevFileName);
        }
        catch (IOException | JAXBException | TransformerException e) {
            throw new SchedulerException(REPORT_ERROR, "Failed to execute CSV report '" + invoiceReport.getItemValueString("txtname") + "' : " + e.getMessage(), (Exception)e);
        }
        filedata.setContentType("text/csv");
        datevExport.addFileData(filedata);
        DatevHelper.logMessage("... CSV export completed (ClientID=" + datevExport.getItemValueString(ITEM_DATEV_CLIENT_ID) + ", " + data.size() + " invoices)", configuration, datevExport);
    }

    public boolean putFileData(FileData fileData, ItemCollection configuration, String subDirectory, ItemCollection datevExport, int ftpType) throws SchedulerException {
        boolean result;
        block22: {
            result = false;
            String ftpServer = configuration.getItemValueString(ITEM_FTP_HOST);
            String datevClientID = datevExport.getItemValueString(ITEM_DATEV_CLIENT_ID);
            if (ftpServer.isEmpty()) {
                return false;
            }
            String ftpPort = configuration.getItemValueString(ITEM_FTP_PORT);
            if (ftpPort.isEmpty()) {
                ftpPort = "21";
            }
            String ftpUser = configuration.getItemValueString(ITEM_FTP_USER);
            String ftpPassword = configuration.getItemValueString(ITEM_FTP_PASSWORD);
            Object ftpPathReports = configuration.getItemValueString(ITEM_FTP_PATH_UPLOAD);
            Object ftpParentPath = null;
            if (!((String)ftpPathReports).startsWith("/")) {
                ftpPathReports = "/" + (String)ftpPathReports;
            }
            if (!((String)ftpPathReports).endsWith("/")) {
                ftpPathReports = (String)ftpPathReports + "/";
            }
            if (!((String)(ftpPathReports = (String)ftpPathReports + subDirectory)).endsWith("/")) {
                ftpPathReports = (String)ftpPathReports + "/";
            }
            ftpParentPath = ftpPathReports;
            if (!((String)(ftpPathReports = (String)ftpPathReports + datevClientID)).endsWith("/")) {
                ftpPathReports = (String)ftpPathReports + "/";
            }
            InputStream writer = null;
            FTPSClient ftpClient = null;
            try {
                logger.finest("......put " + fileData.getName() + " to FTP server: " + ftpServer + "...");
                ftpClient = new FTPSClient("TLS", false);
                ftpClient.setControlEncoding("UTF-8");
                ftpClient.connect(ftpServer, Integer.parseInt(ftpPort));
                if (!ftpClient.login(ftpUser, ftpPassword)) {
                    throw new SchedulerException(ITEM_FTP_ERROR, "FTP file transfer failed: login failed!");
                }
                ftpClient.enterLocalPassiveMode();
                logger.finest("...... FileType=" + ftpType);
                ftpClient.setFileType(ftpType);
                ftpClient.setControlEncoding("UTF-8");
                writer = new ByteArrayInputStream(fileData.getContent());
                FTPFile[] subDirectories = ftpClient.listDirectories((String)ftpParentPath);
                boolean bSubDirFound = false;
                for (FTPFile ftpFile : subDirectories) {
                    if (!ftpFile.isDirectory() || !ftpFile.getName().equals(datevClientID)) continue;
                    bSubDirFound = true;
                    break;
                }
                if (!bSubDirFound) {
                    logger.info("... creating subdirectory " + datevClientID);
                    if (ftpClient.makeDirectory((String)ftpPathReports)) {
                        logger.info("... subdirectory '" + datevClientID + "' created");
                    }
                } else {
                    logger.info("...  subdirectory " + datevClientID + " already exists");
                }
                if (result = ftpClient.storeFile((String)ftpPathReports + fileData.getName(), writer)) {
                    DatevHelper.logMessage("...FTP file transfer '" + (String)ftpPathReports + fileData.getName() + "' successfull", configuration, datevExport);
                    break block22;
                }
                throw new SchedulerException(ITEM_FTP_ERROR, "FTP file transfer failed: unable to write '" + (String)ftpPathReports + fileData.getName() + "'");
            }
            catch (IOException e) {
                logger.severe("FTP I/O Error: " + e.getMessage());
                int r = ftpClient.getReplyCode();
                logger.severe("FTP ReplyCode=" + r);
                throw new SchedulerException(ITEM_FTP_ERROR, "FTP file transfer failed (replyCode=" + r + ") : " + e.getMessage(), (Exception)e);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
                catch (IOException e) {
                    throw new SchedulerException(ITEM_FTP_ERROR, "FTP file transfer failed: " + e.getMessage(), (Exception)e);
                }
            }
        }
        return result;
    }

    public ItemCollection buildExportWorkitem(ItemCollection configuration, String modelVersion, int taskID, List<ItemCollection> data) {
        ItemCollection firstInvoice;
        ItemCollection datevExport = new ItemCollection().model(modelVersion).task(taskID);
        datevExport.replaceItemValue("$created", (Object)new Date());
        datevExport.replaceItemValue("$modified", (Object)new Date());
        datevExport.setItemValue("$uniqueid", (Object)WorkflowKernel.generateUniqueID());
        datevExport.setItemValue("$workflowgroup", (Object)"DATEV-Export");
        if (data != null && data.size() > 0 && (firstInvoice = data.get(0)).hasItem(ITEM_DATEV_FISCAL_START)) {
            datevExport.setItemValue(ITEM_DATEV_FISCAL_START, (Object)firstInvoice.getItemValue(ITEM_DATEV_FISCAL_START));
            datevExport.setItemValue(ITEM_DATEV_CLIENT_ID, (Object)firstInvoice.getItemValue(ITEM_DATEV_CLIENT_ID));
            datevExport.setItemValue(ITEM_DATEV_KONTENLAENGE, (Object)firstInvoice.getItemValue(ITEM_DATEV_KONTENLAENGE));
            datevExport.setItemValue(ITEM_DATEV_CONSULTANT_ID, (Object)firstInvoice.getItemValue(ITEM_DATEV_CONSULTANT_ID));
        }
        if (datevExport.getItemValueString(ITEM_DATEV_CONSULTANT_ID).isEmpty()) {
            datevExport.setItemValue(ITEM_DATEV_CONSULTANT_ID, (Object)configuration.getItemValue(ITEM_DATEV_CONSULTANT_ID));
        }
        return datevExport;
    }

    public ItemCollection loadConfiguration(String name) {
        try {
            String sQuery = "(type:\"scheduler\" AND (name:\"" + name + "\" OR txtname:\"" + name + "\" ) )";
            List col = this.documentService.find(sQuery, 1, 0);
            if (col.size() > 0) {
                ItemCollection configuration = (ItemCollection)col.iterator().next();
                return configuration;
            }
        }
        catch (QueryException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public String computeKey(ItemCollection invoice) {
        String datevClientID = invoice.getItemValueString(ITEM_DATEV_CLIENT_ID);
        Date datInvoice = invoice.getItemValueDate("_invoicedate");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        String keyPeriode = df.format(datInvoice);
        String key = keyPeriode + "_" + datevClientID;
        return key;
    }

    public ItemCollection findDatevExport(String datevKey) throws QueryException {
        String query = "(type:workitem) AND ($taskid:1000) AND ($modelversion:datev-export-de-2*) ";
        List resultList = this.documentService.find(query, 999, 0, "$modified", true);
        for (ItemCollection export : resultList) {
            if (!datevKey.equals(export.getItemValueString("name"))) continue;
            return export;
        }
        return null;
    }

    public ItemCollection processDatevExport(ItemCollection datevExport) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        return this.workflowService.processWorkItem(datevExport);
    }

    public FileData getWorkItemFileFromWorkitem(ItemCollection invoice) throws PluginException {
        if (invoice != null) {
            String snapshotID = invoice.getItemValueString("$snapshotid");
            ItemCollection snapshot = this.documentService.load(snapshotID);
            if (snapshot != null) {
                FileData lastFileData = null;
                List fileDataList = snapshot.getFileData();
                for (FileData fileData : fileDataList) {
                    if (!fileData.getName().toLowerCase().endsWith(".pdf")) continue;
                    if (lastFileData == null) {
                        lastFileData = fileData;
                        continue;
                    }
                    ItemCollection attributes = new ItemCollection(fileData.getAttributes());
                    ItemCollection lastAttributes = new ItemCollection(lastFileData.getAttributes());
                    Date date = attributes.getItemValueDate("$created");
                    Date lastDate = lastAttributes.getItemValueDate("$created");
                    if (date == null || lastDate == null || date.compareTo(lastDate) <= 0) continue;
                    lastFileData = fileData;
                }
                return lastFileData;
            }
        } else {
            throw new PluginException(DatevExportService.class.getName(), MODEL_ERROR, "Invoice Document not defined");
        }
        return null;
    }
}

