/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.export;

import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.datev.DatevException;
import org.imixs.workflow.datev.export.DatevExportService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

public class DatevRefAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(DatevRefAdapter.class.getName());
    public static final String ERROR_MISSING_DATA = "MISSING_DATA";
    public static final String ERROR_CONFIG = "CONFIG_ERROR";
    @Inject
    @ConfigProperty(name="datev.defaultkonto", defaultValue="1370")
    private String datevDefaultKonto;
    @Inject
    DatevExportService datevExportService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException, PluginException {
        this.validateDefaultBooking(document);
        this.appendInvoice(document);
        return document;
    }

    private void appendInvoice(ItemCollection invoice) throws PluginException {
        ItemCollection datevConfig = this.datevExportService.loadConfiguration("DATEV_CONFIGURATION");
        if (datevConfig == null) {
            throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "Datev Export kann nicht erzeugt werden da keine DATEV Konfiguration vorliegt.");
        }
        String datevClientID = datevConfig.getItemValueString("datev.client.id");
        if (datevClientID == null || datevClientID.isEmpty()) {
            throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "Datev Export kann nicht erzeugt werden da keine DATEV Client ID definiert wurde. Bitte pr\u00fcfen Sie die DATEV Konfiguration.");
        }
        Date datInvoice = invoice.getItemValueDate("invoice.date");
        if (datInvoice == null) {
            throw new PluginException(PluginException.class.getName(), ERROR_MISSING_DATA, "Datev Export kann nicht erzeugt werden da kein Buchungsdatum angegeben wurde.");
        }
        String key = this.datevExportService.computeKey(invoice, datevClientID);
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM");
        String keyPeriode = df.format(datInvoice);
        logger.info("......Update DATEV export for: '" + key + "'...");
        try {
            List refList;
            ItemCollection datevExport = this.datevExportService.findDatevExport(key);
            if (datevExport == null) {
                datevExport = new ItemCollection().workflowGroup("DATEV-Export").task(1000);
                datevExport.setItemValue("datev.client.id", (Object)datevConfig.getItemValue("datev.client.id"));
                datevExport.setItemValue("datev.client.name", (Object)datevConfig.getItemValue("datev.client.name"));
                datevExport.setItemValue("datev.booking_period", (Object)keyPeriode);
                datevExport.setItemValue("name", (Object)key);
            }
            if (!(refList = datevExport.getItemValue("$workitemref")).contains(invoice.getUniqueID())) {
                datevExport.appendItemValueUnique("$workitemref", (Object)invoice.getUniqueID());
                datevExport.event(100);
                this.datevExportService.processDatevExport(datevExport);
            }
        }
        catch (AccessDeniedException | ModelException | ProcessingErrorException | QueryException e1) {
            throw new DatevException(DatevRefAdapter.class.getName(), ERROR_MISSING_DATA, "Es konnte kein DATEV Export zugewiesen werden: " + e1.getMessage());
        }
    }

    private void validateDefaultBooking(ItemCollection invoice) {
        List<ItemCollection> buchunssaetze = this.explodeChildList(invoice);
        if (buchunssaetze.size() == 0 || buchunssaetze.size() == 1 && buchunssaetze.get(0).getItemValueString("_konto").isEmpty()) {
            ItemCollection bookingItem = null;
            bookingItem = buchunssaetze.size() == 0 ? new ItemCollection() : buchunssaetze.get(0);
            bookingItem.setItemValue("_konto", (Object)this.datevDefaultKonto);
            bookingItem.setItemValue("_amount", (Object)invoice.getItemValue("invoice.amount"));
            if (buchunssaetze.size() == 1) {
                buchunssaetze.remove(0);
            }
            buchunssaetze.add(bookingItem);
        }
        this.implodeChildList(invoice, buchunssaetze);
    }

    protected void implodeChildList(ItemCollection workitem, List<ItemCollection> childItems) {
        ArrayList<Map> mapOrderItems = new ArrayList<Map>();
        if (childItems != null) {
            logger.fine("Convert child items into Map...");
            for (ItemCollection orderItem : childItems) {
                mapOrderItems.add(orderItem.getAllItems());
            }
            workitem.replaceItemValue("_ChildItems", mapOrderItems);
        }
    }

    protected List<ItemCollection> explodeChildList(ItemCollection workitem) {
        ArrayList<ItemCollection> childItems = new ArrayList<ItemCollection>();
        List mapOrderItems = workitem.getItemValue("_ChildItems");
        int pos = 1;
        for (Object mapOderItem : mapOrderItems) {
            if (!(mapOderItem instanceof Map)) continue;
            ItemCollection itemCol = new ItemCollection((Map)mapOderItem);
            itemCol.replaceItemValue("numPos", (Object)pos);
            childItems.add(itemCol);
            ++pos;
        }
        return childItems;
    }
}

