/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.imports;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;

public class DatevImportAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(DatevImportAdapter.class.getName());
    public static final String DATEV_IMPORT_ERROR = "DATEV_IMPORT_ERROR";
    public static final String ENCODING = "ISO-8859-1";

    public ItemCollection execute(ItemCollection workitem, ItemCollection event) throws AdapterException, PluginException {
        logger.info("...start datev file import...");
        this.validateDATEVFile(workitem);
        this.readHeader(workitem);
        return workitem;
    }

    private void validateDATEVFile(ItemCollection workitem) throws PluginException {
        List fileDataList = workitem.getFileData();
        if (fileDataList.size() != 1) {
            throw new PluginException(DatevImportAdapter.class.getName(), DATEV_IMPORT_ERROR, "Only one file expected!");
        }
        FileData fileData = (FileData)fileDataList.get(0);
        String filename = fileData.getName().toLowerCase();
        if (!filename.startsWith("dtvf_") && !filename.startsWith("extf_")) {
            throw new PluginException(DatevImportAdapter.class.getName(), DATEV_IMPORT_ERROR, "DTVF or EXTF prefix expected!");
        }
        if (!filename.endsWith(".csv")) {
            throw new PluginException(DatevImportAdapter.class.getName(), DATEV_IMPORT_ERROR, ".csv suffix expected!");
        }
    }

    private void readHeader(ItemCollection workitem) throws PluginException {
        FileData fileData = (FileData)workitem.getFileData().get(0);
        ByteArrayInputStream imputStream = new ByteArrayInputStream(fileData.getContent());
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)imputStream, ENCODING));
            String header1 = in.readLine();
            String[] header1List = header1.split(";(?=([^\"]*\"[^\"]*\")*[^\"]*$)", 99);
            if (header1List.length < 13) {
                throw new PluginException(DatevImportAdapter.class.getName(), DATEV_IMPORT_ERROR, "Invalid header-1!");
            }
            workitem.setItemValue("datev.format-kz", (Object)DatevImportAdapter.csvVal(header1List[0]));
            workitem.setItemValue("datev.Versionsnummer", (Object)DatevImportAdapter.csvVal(header1List[1]));
            workitem.setItemValue("datev.Datenkategorie", (Object)DatevImportAdapter.csvVal(header1List[2]));
            workitem.setItemValue("datev.Formatname", (Object)DatevImportAdapter.csvVal(header1List[3]));
            workitem.setItemValue("datev.Erzeugt_am", (Object)DatevImportAdapter.csvVal(header1List[5]));
            workitem.setItemValue("datev.WJ-Beginn", (Object)DatevImportAdapter.csvVal(header1List[12]));
        }
        catch (IOException e) {
            throw new PluginException(DatevImportAdapter.class.getName(), DATEV_IMPORT_ERROR, "Unable to read file", (Exception)e);
        }
    }

    public static String csvVal(String value) {
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }
}

