/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.imports;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.scheduler.SchedulerService;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class DatevService {
    public static final String IMPORT_ERROR = "IMPORT_ERROR";
    public static final String DOCUMENT_TYPE = "configuration";
    @EJB
    DocumentService documentService;
    private static Logger logger = Logger.getLogger(DatevService.class.getName());

    public ItemCollection loadConfiguration(String name) {
        try {
            String sQuery = "(type:\"configuration\" AND (name:\"" + name + "\" OR txtname:\"" + name + "\" ) )";
            List col = this.documentService.find(sQuery, 1, 0);
            if (col.size() > 0) {
                ItemCollection configuration = (ItemCollection)col.iterator().next();
                return configuration;
            }
        }
        catch (QueryException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public ItemCollection saveConfiguration(ItemCollection configuration) {
        String name = configuration.getItemValueString("name");
        if (name.isEmpty()) {
            name = configuration.getItemValueString("txtname");
            configuration.replaceItemValue("name", (Object)name);
        }
        if (name == null || name.isEmpty()) {
            throw new InvalidAccessException(SchedulerService.class.getName(), "INVALID_WORKITEM", " scheduler configuraiton must contain the item 'name'");
        }
        configuration.replaceItemValue("type", (Object)DOCUMENT_TYPE);
        configuration.replaceItemValue("$snapshot.history", (Object)1);
        configuration.replaceItemValue("$writeAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        configuration.replaceItemValue("$readAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        configuration = this.documentService.save(configuration);
        return configuration;
    }
}

