/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.export;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.datev.DatevService;
import org.imixs.workflow.datev.export.DatevExportService;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;

public class DatevExportAdapter
implements SignalAdapter {
    public static final int EVENT_INVOICE_COMPLETED = 200;
    private static Logger logger = Logger.getLogger(DatevExportAdapter.class.getName());
    @Inject
    WorkflowService workflowService;
    @Inject
    DocumentService documentService;
    @Inject
    DatevExportService datevExportService;
    @Inject
    DatevService datevService;

    public ItemCollection execute(ItemCollection datevExport, ItemCollection event) throws AdapterException, PluginException {
        try {
            ItemCollection configuration = this.datevService.loadConfiguration();
            List<ItemCollection> masterDataSet = this.buildMasterDataSet(datevExport);
            this.datevExportService.updateExportWorkitem(datevExport, configuration, masterDataSet);
            String datevClientID = datevExport.getItemValueString("datev.client.id");
            if (masterDataSet.size() > 0) {
                this.datevExportService.buildCSVFile(datevExport, masterDataSet, datevClientID, configuration);
                this.datevExportService.buildDocumentsZipFile(datevExport, masterDataSet, datevClientID, configuration);
                List files = datevExport.getFileData();
                for (FileData filedata : files) {
                    if (filedata.getName().endsWith(".csv")) {
                        this.datevExportService.putFileData(filedata, configuration, configuration.getItemValueString("_datev_ftp_path_buchungsstapel"), datevExport, 0);
                    }
                    if (!filedata.getName().endsWith(".zip")) continue;
                    this.datevExportService.putFileData(filedata, configuration, configuration.getItemValueString("_datev_ftp_path_belege"), datevExport, 2);
                }
            }
        }
        catch (AccessDeniedException | ProcessingErrorException e) {
            throw new PluginException(DatevExportAdapter.class.getName(), "DATEV_EXPORT_ERROR", e.getMessage(), (Exception)e);
        }
        return datevExport;
    }

    private List<ItemCollection> buildMasterDataSet(ItemCollection workitem) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        List uniqueIDs = workitem.getItemValue("$workitemref");
        for (String id : uniqueIDs) {
            ItemCollection invoice = this.workflowService.getWorkItem(id);
            if (invoice != null) {
                result.add(invoice);
                continue;
            }
            logger.warning("Invoice '" + id + "' no longer valid. Invoice will be excluded from DATEV export.");
        }
        Collections.sort(result, new ItemCollectionComparator("$created", true));
        return result;
    }
}

