/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.export;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.datev.DatevHelper;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ReportService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XSLHandler;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@LocalBean
public class DatevExportService {
    public static final String ITEM_FTP_HOST = "datev.ftp.host";
    public static final String ITEM_FTP_PORT = "datev.ftp.port";
    public static final String ITEM_FTP_USER = "datev.ftp.userid";
    public static final String ITEM_FTP_PASSWORD = "datev.ftp.password";
    public static final String ITEM_FTP_PATH_UPLOAD = "_datev.ftp.path.upload";
    public static final String ITEM_FTP_ERROR = "_ftp_error";
    @Inject
    WorkflowService workflowService;
    @Inject
    DocumentService documentService;
    @Inject
    ReportService reportService;
    private static Logger logger = Logger.getLogger(DatevExportService.class.getName());

    public ItemCollection updateExportWorkitem(ItemCollection datevExport, ItemCollection configuration, List<ItemCollection> data) {
        if (data != null && data.size() > 0) {
            ItemCollection firstInvoice = data.get(0);
            if (firstInvoice.hasItem("datev.fiscal_start")) {
                datevExport.setItemValue("datev.fiscal_start", (Object)firstInvoice.getItemValue("datev.fiscal_start"));
                datevExport.setItemValue("datev.client.id", (Object)firstInvoice.getItemValue("datev.client.id"));
                datevExport.setItemValue("datev.sachkontennummernlaenge", (Object)firstInvoice.getItemValue("datev.sachkontennummernlaenge"));
            } else {
                Object fs = configuration.getItemValueString("datev.fiscal_start");
                Date invoiceDate = firstInvoice.getItemValueDate("invoice.date");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(invoiceDate);
                fs = calendar.get(1) + (String)fs;
                datevExport.setItemValue("datev.fiscal_start", fs);
            }
        }
        if (datevExport.getItemValueString("datev.consultant.id").isEmpty()) {
            datevExport.setItemValue("datev.consultant.id", (Object)configuration.getItemValue("datev.consultant.id"));
        }
        return datevExport;
    }

    public void buildDocumentsZipFile(ItemCollection datevExport, List<ItemCollection> data, String key, ItemCollection configuration) throws PluginException {
        int documentCount = 0;
        ZipOutputStream datevZip = null;
        ByteArrayOutputStream zipOutputStream = null;
        DatevHelper.logMessage("... Document export started (ClientID=" + datevExport.getItemValueString("datev.client.id") + ") ...", configuration, datevExport);
        String reportNameDocuments = configuration.getItemValueString("report.documents");
        ItemCollection documentsReport = this.reportService.findReport(reportNameDocuments);
        if (documentsReport == null) {
            throw new PluginException(this.getClass().getClass().getName(), "DATEV_REPORT_ERROR", "unable to load documents report definition '" + reportNameDocuments + "'. Please check the configuration");
        }
        try {
            zipOutputStream = new ByteArrayOutputStream();
            datevZip = new ZipOutputStream(zipOutputStream);
            String xslDocuments = documentsReport.getItemValueString("XSL").trim();
            if (xslDocuments.isEmpty()) {
                throw new PluginException(this.getClass().getClass().getName(), "DATEV_REPORT_ERROR", "Failed to build DATEV zip archive '" + documentsReport.getItemValueString("txtname") + " XSL content is missing.");
            }
            String encoding = documentsReport.getItemValueString("encoding");
            for (ItemCollection exportDataEntity : data) {
                FileData fileData = this.getWorkItemFileFromWorkitem(exportDataEntity);
                if (fileData == null) continue;
                exportDataEntity.removeFile(fileData.getName());
                fileData.setName(exportDataEntity.getUniqueID() + ".pdf");
                try {
                    datevZip.putNextEntry(new ZipEntry(fileData.getName()));
                    datevZip.write(fileData.getContent());
                    datevZip.closeEntry();
                    ++documentCount;
                    DatevHelper.logMessage("......." + fileData.getName() + " added. ", configuration, datevExport);
                }
                catch (ZipException ezip) {
                    DatevHelper.logMessage(".......WARNING : " + ezip.getClass().getSimpleName() + " -> " + ezip.getMessage(), configuration, datevExport);
                }
                Object empty = new byte[0];
                fileData.setContent((byte[])empty);
                exportDataEntity.addFileData(fileData);
            }
            ByteArrayOutputStream outputStream = null;
            try {
                ArrayList<ItemCollection> uniqueDataSource = new ArrayList<ItemCollection>();
                ArrayList<String> idList = new ArrayList<String>();
                for (ItemCollection inovice : data) {
                    if (idList.contains(inovice.getUniqueID())) continue;
                    uniqueDataSource.add(inovice);
                    idList.add(inovice.getUniqueID());
                }
                byte[] xmlData = XMLDataCollectionAdapter.writeItemCollection(uniqueDataSource);
                outputStream = new ByteArrayOutputStream();
                String xml = new String(xmlData);
                XSLHandler.transform((String)new String(xml), (String)xslDocuments, (String)encoding, (OutputStream)outputStream);
                byte[] byteData = outputStream.toByteArray();
                datevZip.putNextEntry(new ZipEntry("document.xml"));
                datevZip.write(byteData);
                datevZip.closeEntry();
            }
            catch (JAXBException | IOException | TransformerException e) {
                throw new PluginException(DatevExportService.class.getName(), "DATEV_REPORT_ERROR", "Failed to build DATEV zip archive '" + documentsReport.getItemValueString("txtname") + "' : " + e.getMessage(), (Exception)e);
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HHmm");
            String datevFileName = "datev_documents_" + key + "_" + df.format(new Date()) + ".zip";
            datevZip.finish();
            datevZip.close();
            zipOutputStream.close();
            FileData zipFileData = new FileData(datevFileName, zipOutputStream.toByteArray(), "application/zip", null);
            datevExport.addFileData(zipFileData);
        }
        catch (IOException e) {
            throw new PluginException(DatevExportService.class.getName(), "DATEV_REPORT_ERROR", "Failed to create Documents archive '" + documentsReport.getItemValueString("txtname") + "' : " + e.getClass().getName() + " -> " + e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (datevZip != null) {
                    datevZip.close();
                }
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (IOException e) {
                throw new PluginException(DatevExportService.class.getName(), "DATEV_REPORT_ERROR", "Failed to close DATEV archive '" + documentsReport.getItemValueString("txtname") + "' : " + e.getMessage(), (Exception)e);
            }
        }
        DatevHelper.logMessage("... Document export completed (ClientID=" + datevExport.getItemValueString("datev.client.id") + ", " + documentCount + " documents)", configuration, datevExport);
    }

    public void buildCSVFile(ItemCollection datevExport, List<ItemCollection> data, String key, ItemCollection configuration) throws PluginException {
        FileData filedata;
        String clientID = datevExport.getItemValueString("datev.client.id");
        String reportNameInvoices = configuration.getItemValueString("report.invoices");
        DatevHelper.logMessage("... CSV export started (ClientID=" + clientID + ") Report=" + reportNameInvoices + "...", configuration, datevExport);
        ItemCollection invoiceReport = null;
        invoiceReport = this.reportService.findReport(reportNameInvoices);
        if (invoiceReport == null) {
            throw new PluginException(DatevExportService.class.getName(), "DATEV_REPORT_ERROR", "unable to load invoice report definition '" + reportNameInvoices + "'. Please check the configuration");
        }
        LocalDateTime stapelZeitraumStart = null;
        LocalDateTime stapelZeitraumEnde = null;
        for (ItemCollection invoice : data) {
            Date baseDate = invoice.getItemValueDate("accounting.date");
            if (baseDate == null) {
                baseDate = invoice.getItemValueDate("invoice.date");
            }
            LocalDateTime invoiceDate = new Date(baseDate.getTime()).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (stapelZeitraumStart == null || stapelZeitraumStart.isAfter(invoiceDate)) {
                stapelZeitraumStart = invoiceDate;
            }
            if (stapelZeitraumEnde != null && !invoiceDate.isAfter(stapelZeitraumEnde)) continue;
            stapelZeitraumEnde = invoiceDate;
        }
        if (stapelZeitraumStart != null) {
            datevExport.replaceItemValue("datev.stapelzeitraum.start", (Object)Date.from(stapelZeitraumStart.atZone(ZoneId.systemDefault()).toInstant()));
            datevExport.replaceItemValue("datev.stapelzeitraum.ende", (Object)Date.from(stapelZeitraumEnde.atZone(ZoneId.systemDefault()).toInstant()));
        }
        ArrayList<ItemCollection> tmp_data = new ArrayList<ItemCollection>();
        tmp_data.addAll(data);
        tmp_data.add(datevExport);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HHmm");
        String datevFileName = "EXTF_Buchungsstapel_" + key + "_" + df.format(new Date()) + ".csv";
        try {
            filedata = this.reportService.transformDataSource(invoiceReport, tmp_data, datevFileName);
        }
        catch (JAXBException | IOException | TransformerException e) {
            throw new PluginException(DatevExportService.class.getName(), "DATEV_REPORT_ERROR", "Failed to execute CSV report '" + invoiceReport.getItemValueString("txtname") + "' : " + e.getMessage(), (Exception)e);
        }
        filedata.setContentType("text/csv");
        datevExport.addFileData(filedata);
        DatevHelper.logMessage("... CSV export completed (ClientID=" + datevExport.getItemValueString("datev.client.id") + ", " + data.size() + " invoices)", configuration, datevExport);
    }

    public boolean putFileData(FileData fileData, ItemCollection configuration, String subDirectory, ItemCollection datevExport, int ftpType) throws PluginException {
        boolean result;
        block22: {
            result = false;
            String ftpServer = configuration.getItemValueString(ITEM_FTP_HOST);
            String datevClientID = datevExport.getItemValueString("datev.client.id");
            if (ftpServer.isEmpty()) {
                return false;
            }
            String ftpPort = configuration.getItemValueString(ITEM_FTP_PORT);
            if (ftpPort.isEmpty()) {
                ftpPort = "21";
            }
            String ftpUser = configuration.getItemValueString(ITEM_FTP_USER);
            String ftpPassword = configuration.getItemValueString(ITEM_FTP_PASSWORD);
            Object ftpPathReports = configuration.getItemValueString(ITEM_FTP_PATH_UPLOAD);
            Object ftpParentPath = null;
            if (!((String)ftpPathReports).startsWith("/")) {
                ftpPathReports = "/" + (String)ftpPathReports;
            }
            if (!((String)ftpPathReports).endsWith("/")) {
                ftpPathReports = (String)ftpPathReports + "/";
            }
            if (!((String)(ftpPathReports = (String)ftpPathReports + subDirectory)).endsWith("/")) {
                ftpPathReports = (String)ftpPathReports + "/";
            }
            ftpParentPath = ftpPathReports;
            if (!((String)(ftpPathReports = (String)ftpPathReports + datevClientID)).endsWith("/")) {
                ftpPathReports = (String)ftpPathReports + "/";
            }
            InputStream writer = null;
            FTPSClient ftpClient = null;
            try {
                logger.finest("......put " + fileData.getName() + " to FTP server: " + ftpServer + "...");
                ftpClient = new FTPSClient("TLS", false);
                ftpClient.setControlEncoding("UTF-8");
                ftpClient.connect(ftpServer, Integer.parseInt(ftpPort));
                if (!ftpClient.login(ftpUser, ftpPassword)) {
                    throw new PluginException(DatevExportService.class.getName(), ITEM_FTP_ERROR, "FTP file transfer failed: login failed!");
                }
                ftpClient.enterLocalPassiveMode();
                logger.finest("...... FileType=" + ftpType);
                ftpClient.setFileType(ftpType);
                ftpClient.setControlEncoding("UTF-8");
                writer = new ByteArrayInputStream(fileData.getContent());
                FTPFile[] subDirectories = ftpClient.listDirectories((String)ftpParentPath);
                boolean bSubDirFound = false;
                for (FTPFile ftpFile : subDirectories) {
                    if (!ftpFile.isDirectory() || !ftpFile.getName().equals(datevClientID)) continue;
                    bSubDirFound = true;
                    break;
                }
                if (!bSubDirFound) {
                    logger.info("... creating subdirectory " + datevClientID);
                    if (ftpClient.makeDirectory((String)ftpPathReports)) {
                        logger.info("... subdirectory '" + datevClientID + "' created");
                    }
                } else {
                    logger.info("...  subdirectory " + datevClientID + " already exists");
                }
                if (result = ftpClient.storeFile((String)ftpPathReports + fileData.getName(), writer)) {
                    DatevHelper.logMessage("...FTP file transfer '" + (String)ftpPathReports + fileData.getName() + "' successful", configuration, datevExport);
                    break block22;
                }
                throw new PluginException(DatevExportService.class.getName(), ITEM_FTP_ERROR, "FTP file transfer failed: unable to write '" + (String)ftpPathReports + fileData.getName() + "'");
            }
            catch (IOException e) {
                logger.severe("FTP I/O Error: " + e.getMessage());
                int r = ftpClient.getReplyCode();
                logger.severe("FTP ReplyCode=" + r);
                throw new PluginException(DatevExportService.class.getName(), ITEM_FTP_ERROR, "FTP file transfer failed (replyCode=" + r + ") : " + e.getMessage(), (Exception)e);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
                catch (IOException e) {
                    throw new PluginException(DatevExportService.class.getName(), ITEM_FTP_ERROR, "FTP file transfer failed: " + e.getMessage(), (Exception)e);
                }
            }
        }
        return result;
    }

    public ItemCollection buildExportWorkitem(ItemCollection configuration, String modelVersion, int taskID, List<ItemCollection> data) {
        ItemCollection firstInvoice;
        ItemCollection datevExport = new ItemCollection().model(modelVersion).task(taskID);
        datevExport.replaceItemValue("$created", (Object)new Date());
        datevExport.replaceItemValue("$modified", (Object)new Date());
        datevExport.setItemValue("$uniqueid", (Object)WorkflowKernel.generateUniqueID());
        datevExport.setItemValue("$workflowgroup", (Object)"DATEV-Export");
        if (data != null && data.size() > 0 && (firstInvoice = data.get(0)).hasItem("datev.fiscal_start")) {
            datevExport.setItemValue("datev.fiscal_start", (Object)firstInvoice.getItemValue("datev.fiscal_start"));
            datevExport.setItemValue("datev.client.id", (Object)firstInvoice.getItemValue("datev.client.id"));
            datevExport.setItemValue("datev.sachkontennummernlaenge", (Object)firstInvoice.getItemValue("datev.sachkontennummernlaenge"));
            datevExport.setItemValue("datev.consultant.id", (Object)firstInvoice.getItemValue("datev.consultant.id"));
        }
        if (datevExport.getItemValueString("datev.consultant.id").isEmpty()) {
            datevExport.setItemValue("datev.consultant.id", (Object)configuration.getItemValue("datev.consultant.id"));
        }
        return datevExport;
    }

    public ItemCollection findDatevExport(String datevKey) throws QueryException {
        String query = "(type:workitem) AND ($taskid:1000) AND ($modelversion:datev-export*) ";
        List resultList = this.documentService.find(query, 999, 0, "$modified", true);
        for (ItemCollection export : resultList) {
            if (!datevKey.equals(export.getItemValueString("name"))) continue;
            return export;
        }
        return null;
    }

    public ItemCollection processDatevExport(ItemCollection datevExport) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        return this.workflowService.processWorkItem(datevExport);
    }

    public FileData getWorkItemFileFromWorkitem(ItemCollection invoice) throws PluginException {
        if (invoice != null) {
            String snapshotID = invoice.getItemValueString("$snapshotid");
            ItemCollection snapshot = this.documentService.load(snapshotID);
            if (snapshot != null) {
                FileData lastFileData = null;
                List fileDataList = snapshot.getFileData();
                for (FileData fileData : fileDataList) {
                    if (!fileData.getName().toLowerCase().endsWith(".pdf")) continue;
                    if (lastFileData == null) {
                        lastFileData = fileData;
                        continue;
                    }
                    ItemCollection attributes = new ItemCollection(fileData.getAttributes());
                    ItemCollection lastAttributes = new ItemCollection(lastFileData.getAttributes());
                    Date date = attributes.getItemValueDate("$created");
                    Date lastDate = lastAttributes.getItemValueDate("$created");
                    if (date == null || lastDate == null || date.compareTo(lastDate) <= 0) continue;
                    lastFileData = fileData;
                }
                return lastFileData;
            }
        } else {
            throw new PluginException(DatevExportService.class.getName(), "DATEV_MODEL_ERROR", "Invoice Document not defined");
        }
        return null;
    }
}

