/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.controller;

import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.datev.DatevService;
import org.imixs.workflow.datev.controller.DatevSearchEntry;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.faces.data.WorkflowEvent;

@Named
@ConversationScoped
public class DatevBookingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(DatevBookingController.class.getName());
    protected List<ItemCollection> bookingList = null;
    @Inject
    WorkflowController workflowController;
    @Inject
    DatevService datevService;
    private List<DatevSearchEntry> searchResult = null;

    public void setBookingList(List<ItemCollection> bookingList) {
        this.bookingList = bookingList;
    }

    public List<ItemCollection> getBookingList() {
        return this.bookingList;
    }

    public void add() {
        if (this.bookingList != null) {
            ItemCollection itemCol = new ItemCollection();
            itemCol.replaceItemValue("numPos", (Object)(this.bookingList.size() + 1));
            this.bookingList.add(itemCol);
        }
    }

    public void remove(int pos) {
        if (this.bookingList != null) {
            this.bookingList.remove(pos - 1);
        }
        int iPos = 1;
        for (ItemCollection item : this.bookingList) {
            item.replaceItemValue("numPos", (Object)iPos);
            ++iPos;
        }
    }

    public void onWorkflowEvent(@Observes WorkflowEvent workflowEvent) throws AccessDeniedException {
        int eventType = workflowEvent.getEventType();
        ItemCollection workitem = workflowEvent.getWorkitem();
        if (workitem == null) {
            return;
        }
        if (21 == eventType || 20 == eventType) {
            this.bookingList = DatevBookingController.explodeChildList(workitem, "datev.booking.list");
        }
        if (22 == eventType) {
            DatevBookingController.implodeChildList(workitem, this.bookingList, "datev.booking.list");
        }
        if (23 == eventType) {
            this.bookingList = DatevBookingController.explodeChildList(workitem, "datev.booking.list");
        }
    }

    public static List<ItemCollection> explodeChildList(ItemCollection workitem, String childItemName) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        List mapOrderItems = workitem.getItemValue(childItemName);
        for (Object mapOderItem : mapOrderItems) {
            if (!(mapOderItem instanceof Map)) continue;
            ItemCollection itemCol = new ItemCollection((Map)mapOderItem);
            result.add(itemCol);
        }
        return result;
    }

    public static void implodeChildList(ItemCollection workitem, List<ItemCollection> _childItems, String childItemName) {
        ArrayList<Map> mapOrderItems = new ArrayList<Map>();
        if (_childItems != null) {
            for (ItemCollection orderItem : _childItems) {
                mapOrderItems.add(orderItem.getAllItems());
            }
            workitem.replaceItemValue(childItemName, mapOrderItems);
        }
    }
}

