/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.controller;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.SessionScoped;
import jakarta.faces.model.SelectItem;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.datev.DatevService;
import org.imixs.workflow.datev.imports.DatevImportService;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.index.UpdateService;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.faces.data.WorkflowController;
import org.imixs.workflow.faces.fileupload.FileUploadController;

@Named
@SessionScoped
public class DatevController
implements Serializable {
    private ItemCollection importData;
    private ItemCollection configuration = null;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(DatevController.class.getName());
    @Inject
    DocumentService documentService;
    @Inject
    UpdateService updateService;
    @Inject
    DatevService datevService;
    @Inject
    DatevImportService datevImportService;
    @Inject
    WorkflowController workflowController;
    @Inject
    protected FileUploadController fileUploadController;

    @PostConstruct
    public void init() {
        this.configuration = this.loadConfiguration();
    }

    public String getName() {
        return "DATEV_CONFIGURATION";
    }

    public ItemCollection getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new ItemCollection();
            this.configuration.setItemValue("$workflowsummary", (Object)this.getName());
            this.configuration.setItemValue("txtname", (Object)this.getName());
        }
        return this.configuration;
    }

    public void setConfiguration(ItemCollection configuration) {
        this.configuration = configuration;
    }

    public ItemCollection loadConfiguration() {
        this.configuration = this.datevService.loadConfiguration();
        return this.configuration;
    }

    public ItemCollection saveConfiguration() {
        this.configuration = this.datevService.saveConfiguration(this.configuration);
        return this.configuration;
    }

    public List<SelectItem> getBuSchluesel() throws Exception {
        ArrayList<SelectItem> selection = new ArrayList<SelectItem>();
        if (!this.configuration.hasItem("datev.buschluessel")) {
            return selection;
        }
        List valueList = this.configuration.getItemValue("datev.buschluessel");
        for (String aValue : valueList) {
            String[] parts = aValue.split("\\|");
            if (parts == null || parts.length < 3) {
                logger.warning("Falsche Konfiguration der _buschluessel - Format: BEZEICHNUNG | DATEV_BU_SCHLUESSEL | PROZENTSATZ");
                continue;
            }
            selection.add(new SelectItem((Object)parts[1].trim(), parts[0].trim()));
        }
        return selection;
    }

    public List<SelectItem> getKostenstelle1() throws Exception {
        ArrayList<SelectItem> selection = new ArrayList<SelectItem>();
        if (this.workflowController.getWorkitem() == null) {
            return selection;
        }
        List valueList = this.configuration.getItemValue("datev.kostenstelle1");
        for (Object aValue : valueList) {
            String sValue = aValue.toString();
            if (sValue.trim().isEmpty()) continue;
            String sName = sValue;
            if (sValue.indexOf("|") > -1) {
                sValue = sValue.substring(0, sValue.indexOf("|"));
                sName = sName.substring(sName.indexOf("|") + 1);
            }
            selection.add(new SelectItem((Object)sValue.trim(), sName.trim()));
        }
        return selection;
    }

    public String getKostenstelle1Read(String value) {
        List valueList = this.configuration.getItemValue("datev.kostenstelle1");
        for (String aValue : valueList) {
            String nummer;
            String[] parts = aValue.split("\\|");
            if (parts == null || parts.length < 1) {
                return value;
            }
            String bez = nummer = parts[0];
            if (parts.length > 1) {
                bez = parts[1];
            }
            if (!value.equals(nummer)) continue;
            if (bez.startsWith(nummer)) {
                return bez;
            }
            return nummer + " " + bez;
        }
        return value;
    }

    public List<SelectItem> getKostenstelle2() throws Exception {
        ArrayList<SelectItem> selection = new ArrayList<SelectItem>();
        if (this.workflowController.getWorkitem() == null) {
            return selection;
        }
        List valueList = this.configuration.getItemValue("datev.kostenstelle2");
        for (Object aValue : valueList) {
            String sValue = aValue.toString();
            if (sValue.trim().isEmpty()) continue;
            String sName = sValue;
            if (sValue.indexOf("|") > -1) {
                sValue = sValue.substring(0, sValue.indexOf("|"));
                sName = sName.substring(sName.indexOf("|") + 1);
            }
            selection.add(new SelectItem((Object)sValue.trim(), sName.trim()));
        }
        return selection;
    }

    public String getKostenstelle2Read(String value) {
        List valueList = this.configuration.getItemValue("datev.kostenstelle2");
        for (String aValue : valueList) {
            String nummer;
            String[] parts = aValue.split("\\|");
            if (parts == null || parts.length < 1) {
                return value;
            }
            String bez = nummer = parts[0];
            if (parts.length > 1) {
                bez = parts[1];
            }
            if (!value.equals(nummer)) continue;
            if (bez.startsWith(nummer)) {
                return bez;
            }
            return nummer + " " + bez;
        }
        return value;
    }

    public ItemCollection getImportData() {
        if (this.importData == null) {
            this.importData = new ItemCollection();
        }
        return this.importData;
    }

    public void setImportData(ItemCollection importData) {
        this.importData = importData;
    }

    public void startImport() throws PluginException {
        List fileList = this.importData.getFileData();
        if (fileList == null) {
            return;
        }
        for (FileData file : fileList) {
            logger.info("Import: " + file.getName());
            if (file.getName().toLowerCase().endsWith(".csv")) {
                ByteArrayInputStream input = new ByteArrayInputStream(file.getContent());
                String encoding = this.configuration.getItemValueString("datev.encoding");
                String result = this.datevImportService.importData(input, encoding, file.getName());
                this.getImportData().replaceItemValue("log", (Object)result);
                continue;
            }
            throw new PluginException(this.getClass().getName(), "DATEV_IMPORT_ERROR", "File Format not supported: " + file.getName());
        }
        this.updateService.updateIndex();
        this.importData.removeItem("$file");
    }

    public List<ItemCollection> getBuchungsexportByBelegdatum(ItemCollection workitem) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        List ids = workitem.getItemValue("$workitemref");
        for (String id : ids) {
            ItemCollection invoice = this.documentService.load(id);
            result.add(invoice);
        }
        Collections.sort(result, new ItemCollectionComparator("datev.belegdatum", false));
        return result;
    }
}

