/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.export;

import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.datev.DatevException;
import org.imixs.workflow.datev.DatevService;
import org.imixs.workflow.datev.export.DatevExportService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

public class DatevRefAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(DatevRefAdapter.class.getName());
    @Inject
    @ConfigProperty(name="datev.defaultkonto", defaultValue="1370")
    private String datevDefaultKonto;
    @Inject
    DatevExportService datevExportService;
    @Inject
    DatevService datevService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException, PluginException {
        this.validateDefaultBooking(document);
        this.appendWorkitem(document);
        return document;
    }

    private void appendWorkitem(ItemCollection workitem) throws PluginException {
        ItemCollection datevConfig = this.datevService.loadConfiguration();
        if (datevConfig == null) {
            throw new PluginException(PluginException.class.getName(), "DATEV_CONFIG_ERROR", "Datev Export kann nicht erzeugt werden da keine DATEV Konfiguration vorliegt.");
        }
        String datevClientID = datevConfig.getItemValueString("datev.client.id");
        if (datevClientID == null || datevClientID.isEmpty()) {
            throw new PluginException(PluginException.class.getName(), "DATEV_CONFIG_ERROR", "Datev Export kann nicht erzeugt werden da keine DATEV Client ID definiert wurde. Bitte pr\u00fcfen Sie die DATEV Konfiguration.");
        }
        String key = this.datevService.computeKey(workitem, datevClientID);
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM");
        Date datBelegdatum = workitem.getItemValueDate("datev.belegdatum");
        String keyPeriode = df.format(datBelegdatum);
        logger.info("......Update DATEV export for: '" + key + "'...");
        try {
            List refList;
            ItemCollection datevExport = this.datevExportService.findDatevExport(key);
            if (datevExport == null) {
                datevExport = new ItemCollection().workflowGroup("DATEV-Export").task(1000);
                datevExport.setItemValue("datev.client.id", (Object)datevConfig.getItemValue("datev.client.id"));
                datevExport.setItemValue("datev.client.name", (Object)datevConfig.getItemValue("datev.client.name"));
                datevExport.setItemValue("datev.consultant.id", (Object)datevConfig.getItemValue("datev.consultant.id"));
                datevExport.setItemValue("datev.fiscal_start", (Object)datevConfig.getItemValue("datev.fiscal_start"));
                datevExport.setItemValue("datev.booking_period", (Object)keyPeriode);
                datevExport.setItemValue("name", (Object)key);
            }
            if (!(refList = datevExport.getItemValue("$workitemref")).contains(workitem.getUniqueID())) {
                datevExport.appendItemValueUnique("$workitemref", (Object)workitem.getUniqueID());
                datevExport.event(100);
                this.datevExportService.processDatevExport(datevExport);
            }
        }
        catch (AccessDeniedException | ModelException | ProcessingErrorException | QueryException e1) {
            throw new DatevException(DatevRefAdapter.class.getName(), "DATEV_CONFIG_ERROR", "Es konnte kein DATEV Export zugewiesen werden: " + e1.getMessage());
        }
    }

    private void validateDefaultBooking(ItemCollection workitem) {
        List<ItemCollection> buchunssaetze = this.explodeChildList(workitem);
        if (buchunssaetze.size() == 0 || buchunssaetze.size() == 1 && buchunssaetze.get(0).getItemValueString("datev.konto").isEmpty()) {
            ItemCollection bookingItem = null;
            bookingItem = buchunssaetze.size() == 0 ? new ItemCollection() : buchunssaetze.get(0);
            bookingItem.setItemValue("datev.konto", (Object)this.datevDefaultKonto);
            bookingItem.setItemValue("datev.betrag", (Object)workitem.getItemValue("datev.betrag"));
            if (buchunssaetze.size() == 1) {
                buchunssaetze.remove(0);
            }
            buchunssaetze.add(bookingItem);
        }
        this.implodeChildList(workitem, buchunssaetze);
    }

    protected void implodeChildList(ItemCollection workitem, List<ItemCollection> childItems) {
        ArrayList<Map> mapOrderItems = new ArrayList<Map>();
        if (childItems != null) {
            logger.fine("Convert child items into Map...");
            for (ItemCollection orderItem : childItems) {
                mapOrderItems.add(orderItem.getAllItems());
            }
            workitem.replaceItemValue("datev.booking.list", mapOrderItems);
        }
    }

    protected List<ItemCollection> explodeChildList(ItemCollection workitem) {
        ArrayList<ItemCollection> childItems = new ArrayList<ItemCollection>();
        List mapOrderItems = workitem.getItemValue("datev.booking.list");
        int pos = 1;
        for (Object mapOderItem : mapOrderItems) {
            if (!(mapOderItem instanceof Map)) continue;
            ItemCollection itemCol = new ItemCollection((Map)mapOderItem);
            itemCol.replaceItemValue("numPos", (Object)pos);
            childItems.add(itemCol);
            ++pos;
        }
        return childItems;
    }
}

