/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.export;

import jakarta.inject.Inject;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.datev.DatevService;
import org.imixs.workflow.datev.export.DatevExportService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

public class DatevRemoveAdapter
implements SignalAdapter {
    private static Logger logger = Logger.getLogger(DatevRemoveAdapter.class.getName());
    @Inject
    DatevExportService datevExportService;
    @Inject
    DatevService datevService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException, PluginException {
        this.removeWorkitem(document);
        return document;
    }

    private void removeWorkitem(ItemCollection workitem) throws PluginException {
        ItemCollection datevConfig = this.datevService.loadConfiguration();
        if (datevConfig == null) {
            throw new PluginException(PluginException.class.getName(), "DATEV_CONFIG_ERROR", "Datev Export kann nicht erzeugt werden da keine DATEV Konfiguration vorliegt.");
        }
        String datevClientID = datevConfig.getItemValueString("datev.client.id");
        if (datevClientID == null || datevClientID.isEmpty()) {
            throw new PluginException(PluginException.class.getName(), "DATEV_CONFIG_ERROR", "Datev Export kann nicht erzeugt werden da keine DATEV Client ID definiert wurde. Bitte pr\u00fcfen Sie die DATEV Konfiguration.");
        }
        String key = this.datevService.computeKey(workitem, datevClientID);
        logger.info("......Update DATEV export for: '" + key + "'...");
        try {
            List refList;
            ItemCollection datevExport = this.datevExportService.findDatevExport(key);
            if (datevExport != null && (refList = datevExport.getItemValue("$workitemref")).contains(workitem.getUniqueID())) {
                refList.remove(workitem.getUniqueID());
                datevExport.setItemValue("$workitemref", (Object)refList);
                datevExport.event(100);
                this.datevExportService.processDatevExport(datevExport);
            }
        }
        catch (AccessDeniedException | ModelException | ProcessingErrorException | QueryException e1) {
            throw new PluginException(PluginException.class.getName(), "DATEV_DATA_ERROR", "Es konnte kein DATEV Export zugewiesen werden: " + e1.getMessage());
        }
    }
}

