/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.scheduler.SchedulerService;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class DatevService {
    public static final String DOCUMENT_TYPE = "configuration";
    public static final String ITEM_DATEV_KONTENLAENGE = "datev.sachkontennummernlaenge";
    public static final String ITEM_DATEV_CLIENT_ID = "datev.client.id";
    public static final String ITEM_DATEV_CLIENT_NAME = "datev.client.name";
    public static final String ITEM_DATEV_BOOKING_PERIOD = "datev.booking_period";
    public static final String ITEM_DATEV_CONSULTANT_ID = "datev.consultant.id";
    public static final String ITEM_DATEV_FISCAL_START = "datev.fiscal_start";
    public static final String ITEM_DATEV_BETRAG = "datev.betrag";
    public static final String ITEM_DATEV_BELEGDATUM = "datev.belegdatum";
    public static final String ITEM_DATEV_BELEGFELD1 = "datev.belegfeld1";
    public static final String ITEM_DATEV_KONTO = "datev.konto";
    public static final String ITEM_DATEV_GEGENKONTO = "datev.gegenkonto";
    public static final String ITEM_DATEV_BUSCHLUESSEL = "datev.buschluessel";
    public static final String ITEM_DATEV_BOOKING_LIST = "datev.booking.list";
    public static final String DATEV_CONFIGURATION = "DATEV_CONFIGURATION";
    @EJB
    DocumentService documentService;
    private static Logger logger = Logger.getLogger(DatevService.class.getName());

    public ItemCollection loadConfiguration() {
        try {
            String sQuery = "(type:\"configuration\" AND name:\"DATEV_CONFIGURATION\" )";
            List col = this.documentService.find(sQuery, 1, 0);
            if (col.size() > 0) {
                ItemCollection configuration = (ItemCollection)col.iterator().next();
                return configuration;
            }
        }
        catch (QueryException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public ItemCollection saveConfiguration(ItemCollection configuration) {
        String name = configuration.getItemValueString("name");
        if (name.isEmpty()) {
            name = configuration.getItemValueString("txtname");
            configuration.replaceItemValue("name", (Object)name);
        }
        if (name == null || name.isEmpty()) {
            throw new InvalidAccessException(SchedulerService.class.getName(), "INVALID_WORKITEM", " scheduler configuraiton must contain the item 'name'");
        }
        configuration.replaceItemValue("type", (Object)DOCUMENT_TYPE);
        configuration.replaceItemValue("$snapshot.history", (Object)1);
        configuration.replaceItemValue("$writeAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        configuration.replaceItemValue("$readAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        configuration = this.documentService.save(configuration);
        return configuration;
    }

    public String computeKey(ItemCollection workitem, String datevClientID) throws PluginException {
        Date datBelegdatum = workitem.getItemValueDate(ITEM_DATEV_BELEGDATUM);
        if (datBelegdatum == null) {
            throw new PluginException(PluginException.class.getName(), "DATEV_DATA_ERROR", "DATEV Daten Fehler - es wurde kein Belegdatum angegeben!");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        String keyPeriode = df.format(datBelegdatum);
        String key = keyPeriode + "_" + datevClientID;
        return key;
    }
}

