/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.controller;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.datev.DatevService;
import org.imixs.workflow.datev.controller.DatevSearchEntry;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.faces.data.WorkflowController;

@Named
@ConversationScoped
public class DatevSearchController
implements Serializable {
    public static final int MAX_SEARCH_RESULT = 100;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(DatevSearchController.class.getName());
    private ItemCollection configuration = null;
    @Inject
    DocumentService documentService;
    @Inject
    WorkflowController workflowController;
    @Inject
    SchemaService schemaService;
    @Inject
    DatevService datevService;
    private List<DatevSearchEntry> searchResult = null;

    @PostConstruct
    void init() {
        this.configuration = this.datevService.loadConfiguration();
    }

    public void searchSachkonto() {
        this.searchSachkonto(null);
    }

    public void searchSachkonto(String regexPattern) {
        List<ItemCollection> dataList = null;
        this.searchResult = new ArrayList<DatevSearchEntry>();
        FacesContext fc = FacesContext.getCurrentInstance();
        String phrase = (String)fc.getExternalContext().getRequestParameterMap().get("phrase");
        if (phrase == null) {
            return;
        }
        logger.fine("search prase '" + phrase + "'");
        if (phrase == null || phrase.length() < 2) {
            return;
        }
        logger.finest(".......trigger searchSachkonto: " + phrase);
        dataList = this.searchEntity(phrase, "kontenbeschriftungen");
        logger.fine("regex=" + regexPattern);
        Pattern pattern = null;
        if (regexPattern != null && !regexPattern.isEmpty()) {
            pattern = Pattern.compile(regexPattern);
        }
        for (ItemCollection dbtr : dataList) {
            Matcher matcher;
            String kontoNummer = dbtr.getItemValueString("_konto");
            if (pattern != null && !(matcher = pattern.matcher(kontoNummer)).matches()) continue;
            Object display = kontoNummer + " - " + dbtr.getItemValueString("_kontobeschriftung");
            display = ((String)display).replace("\"", "");
            display = ((String)display).replace("'", "");
            this.searchResult.add(new DatevSearchEntry(kontoNummer, (String)display, this.buildSachkontoJsonData(dbtr)));
        }
    }

    public void searchDebitorCreditor(String regexPattern) {
        List<ItemCollection> kontenListe = null;
        this.searchResult = new ArrayList<DatevSearchEntry>();
        FacesContext fc = FacesContext.getCurrentInstance();
        String phrase = (String)fc.getExternalContext().getRequestParameterMap().get("phrase");
        if (phrase == null) {
            return;
        }
        logger.fine("search prase '" + phrase + "'");
        if (phrase == null || phrase.length() < 2) {
            return;
        }
        logger.fine("search for=" + phrase);
        kontenListe = this.searchEntity(phrase, "debitoren/kreditoren");
        logger.fine("regex=" + regexPattern);
        Pattern pattern = null;
        if (regexPattern != null && !regexPattern.isEmpty()) {
            pattern = Pattern.compile(regexPattern);
        }
        for (ItemCollection konto : kontenListe) {
            Matcher matcher;
            String kontoNummer = konto.getItemValueString("_konto");
            if (pattern != null && !(matcher = pattern.matcher(kontoNummer)).matches()) continue;
            String kontoName = konto.getItemValueString("_name");
            konto.setItemValue("_name", (Object)kontoName);
            Object display = kontoNummer + " - " + kontoName;
            display = ((String)display).replace("\"", "");
            display = ((String)display).replace("'", "");
            this.searchResult.add(new DatevSearchEntry(kontoNummer, (String)display, this.buildCdtrJsonData(konto)));
        }
    }

    public List<DatevSearchEntry> getSearchResult() {
        return this.searchResult;
    }

    private String buildSachkontoJsonData(ItemCollection konto) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder().add("konto", DatevSearchController.jsonVal(konto.getItemValueString("_konto"))).add("name", DatevSearchController.jsonVal(konto.getItemValueString("_kontobeschriftung")));
        JsonObject jsonObject = objectBuilder.build();
        String jsonString = "{}";
        try (StringWriter writer = new StringWriter();){
            Json.createWriter((Writer)writer).write((JsonStructure)jsonObject);
            jsonString = ((Object)writer).toString();
        }
        catch (IOException e) {
            logger.warning("Unable to build json structure");
        }
        return jsonString;
    }

    private String buildCdtrJsonData(ItemCollection cdtr) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder().add("konto", DatevSearchController.jsonVal(cdtr.getItemValueString("_konto"))).add("name", DatevSearchController.jsonVal(cdtr.getItemValueString("_name"))).add("iban", DatevSearchController.jsonVal(cdtr.getItemValueString("_iban-nr_1"))).add("iban2", DatevSearchController.jsonVal(cdtr.getItemValueString("_iban-nr_2"))).add("iban3", DatevSearchController.jsonVal(cdtr.getItemValueString("_iban-nr_3"))).add("iban4", DatevSearchController.jsonVal(cdtr.getItemValueString("_iban-nr_4"))).add("iban5", DatevSearchController.jsonVal(cdtr.getItemValueString("_iban-nr_5"))).add("bic", DatevSearchController.jsonVal(cdtr.getItemValueString("_swift-code_1"))).add("bic2", DatevSearchController.jsonVal(cdtr.getItemValueString("_swift-code_2"))).add("bic3", DatevSearchController.jsonVal(cdtr.getItemValueString("_swift-code_3"))).add("bic4", DatevSearchController.jsonVal(cdtr.getItemValueString("_swift-code_4"))).add("bic5", DatevSearchController.jsonVal(cdtr.getItemValueString("_swift-code_5")));
        JsonObject jsonObject = objectBuilder.build();
        String jsonString = "{}";
        try (StringWriter writer = new StringWriter();){
            Json.createWriter((Writer)writer).write((JsonStructure)jsonObject);
            jsonString = ((Object)writer).toString();
        }
        catch (IOException e) {
            logger.warning("Unable to build json structure");
        }
        return jsonString;
    }

    public static String jsonVal(String val) {
        val = val.replace("\"", "");
        val = val.replace("'", "");
        return val;
    }

    public List<ItemCollection> searchEntity(String phrase, String type) {
        ArrayList<ItemCollection> searchResult = new ArrayList<ItemCollection>();
        if (phrase == null || phrase.isEmpty()) {
            return searchResult;
        }
        Collection col = null;
        try {
            phrase = phrase.trim();
            phrase = this.schemaService.normalizeSearchTerm(phrase);
            String sQuery = "(type:\"" + type + "\")";
            sQuery = sQuery + " AND (" + phrase + "*)";
            logger.finest("searchprofile: " + sQuery);
            logger.fine("searchWorkitems: " + sQuery);
            col = this.documentService.find(sQuery, 100, 0);
        }
        catch (Exception e) {
            logger.warning("  lucene error - " + e.getMessage());
        }
        for (ItemCollection kreditor : col) {
            searchResult.add(kreditor);
        }
        Collections.sort(searchResult, new ItemCollectionComparator("txtname", true));
        return searchResult;
    }
}

