/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.datev.imports;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.datev.DatevService;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.index.SchemaService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class DatevImportService {
    public static final int MAX_SEARCH_RESULT = 100;
    public static final String ISO8601_FORMAT_DATETIME = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String ISO8601_FORMAT_DATE = "yyyy-MM-dd";
    @Inject
    DocumentService documentService;
    @Inject
    SchemaService schemaService;
    @Inject
    DatevService datevService;
    private static Logger logger = Logger.getLogger(DatevImportService.class.getName());

    public ItemCollection findEntityByPrimaryKey(String key, String type) {
        String searchTerm = "(type:\"" + type + "\" AND name:\"" + key + "\")";
        try {
            List col = this.documentService.find(searchTerm, 1, 0);
            if (col.size() > 0) {
                return (ItemCollection)col.iterator().next();
            }
        }
        catch (QueryException e) {
            logger.warning(e.getMessage());
        }
        return null;
    }

    public List<ItemCollection> searchEntity(String phrase, String type, String clientID) {
        ArrayList<ItemCollection> searchResult = new ArrayList<ItemCollection>();
        if (phrase == null || phrase.isEmpty()) {
            return searchResult;
        }
        Collection col = null;
        try {
            phrase = phrase.trim();
            phrase = this.schemaService.normalizeSearchTerm(phrase);
            String sQuery = "(type:\"" + type + "\"";
            if (clientID != null && !clientID.isEmpty()) {
                sQuery = sQuery + " AND datev.client.id:\"" + clientID + "\"";
            }
            sQuery = sQuery + ")";
            sQuery = sQuery + " AND (" + phrase + "*)";
            logger.finest("searchprofile: " + sQuery);
            logger.fine("searchWorkitems: " + sQuery);
            col = this.documentService.find(sQuery, 100, 0);
        }
        catch (Exception e) {
            logger.warning("  lucene error - " + e.getMessage());
        }
        for (ItemCollection kreditor : col) {
            searchResult.add(kreditor);
        }
        Collections.sort(searchResult, new ItemCollectionComparator("name", true));
        return searchResult;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String importData(InputStream imputStream, String encoding, String _filename) throws PluginException {
        String type = null;
        String clientID = null;
        String consultenID = null;
        StringBuffer log = new StringBuffer();
        int line = 0;
        long l = System.currentTimeMillis();
        String dataLine = null;
        ArrayList<CallSite> idCache = new ArrayList<CallSite>();
        int workitemsTotal = 0;
        int workitemsImported = 0;
        int workitemsUpdated = 0;
        int workitemsDeleted = 0;
        int workitemsFailed = 0;
        int blockSize = 0;
        this.log(log, "\u251c\u2500\u2500 starte Dateimport");
        if (encoding == null || encoding.trim().isEmpty()) {
            encoding = "UTF-8";
        }
        encoding = encoding.trim();
        this.log(log, "\u2502\u00a0\u00a0 \u251c\u2500\u2500 encoding=" + encoding);
        String fieldNames = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(imputStream, encoding));
            String header = in.readLine();
            String[] headerList = header.split(";(?=([^\"]*\"[^\"]*\")*[^\"]*$)", 99);
            headerList = this.normalizeValueList(headerList);
            if ("DTVF".endsWith(headerList[0])) {
                this.log(log, "\u2502\u00a0\u00a0 \u251c\u2500\u2500 Format: DTVF");
                consultenID = headerList[11];
                this.log(log, "\u2502\u00a0\u00a0 \u251c\u2500\u2500 Berater ID= " + consultenID);
                clientID = headerList[10];
                this.log(log, "\u2502\u00a0\u00a0 \u251c\u2500\u2500 Mandant ID= " + clientID);
                if (clientID == null || clientID.isEmpty() || consultenID == null || consultenID.isEmpty()) {
                    throw new PluginException(this.getClass().getName(), "DATEV_IMPORT_ERROR", "Ung\u00fcltiges DTVF Importformat: Erste Zeile die Mandant ID '" + clientID + "' und die Berater ID '" + consultenID + "' enthalten!");
                }
                type = headerList[3];
                type = type.trim().toLowerCase();
                this.log(log, "\u2502\u00a0\u00a0 \u2514\u2500\u2500 Objekt Typ=" + type);
                fieldNames = in.readLine();
            } else {
                this.log(log, "\u2502\u00a0\u00a0 \u251c\u2500\u2500 Format: CSV/Excel");
                ItemCollection datevConfig = this.datevService.loadConfiguration();
                consultenID = datevConfig.getItemValueString("datev.consultant.id");
                this.log(log, "\u2502\u00a0\u00a0 \u251c\u2500\u2500 Berater ID= " + consultenID);
                clientID = datevConfig.getItemValueString("datev.client.id");
                this.log(log, "\u2502\u00a0\u00a0 \u251c\u2500\u2500 Mandant ID= " + clientID);
                if (_filename.startsWith("DTVF_DebKred_Stamm")) {
                    type = "Debitoren/Kreditoren";
                }
                if (_filename.startsWith("DTVF_SKBeschrift")) {
                    type = "kontenbeschriftungen";
                }
                if (type == null) {
                    throw new PluginException(this.getClass().getName(), "DATEV_IMPORT_ERROR", "Ung\u00fcltiges Importformat: Dateiname muss entweder mit 'DTVF_DebKred_Stamm' oder 'DTVF_SKBeschrift' beginnen!");
                }
                this.log(log, "\u2502\u00a0\u00a0 \u2514\u2500\u2500 Objekt Typ=" + type);
                fieldNames = header;
            }
            this.log(log, "\u251c\u2500\u2500 Lese Daten...");
            List<String> fields = this.parseFieldList(fieldNames);
            String keyField = fields.get(0).trim();
            while ((dataLine = in.readLine()) != null) {
                ++blockSize;
                ++line;
                ++workitemsTotal;
                ItemCollection entity = this.readEntity(dataLine, fields);
                entity.replaceItemValue("datev.client.id", (Object)clientID);
                entity.replaceItemValue("datev.consultant.id", (Object)consultenID);
                String keyValue = entity.getItemValueString(keyField);
                String name = entity.getItemValueString("_kontobeschriftung");
                if (name.isEmpty()) {
                    name = entity.getItemValueString("_name_(adressattyp_unternehmen)");
                }
                if (name.isEmpty()) {
                    name = entity.getItemValueString("_name_(adressattyp_keine_angabe)");
                }
                if (name.isEmpty()) {
                    name = entity.getItemValueString("_name_(adressattyp_nat\u00fcrl_person)");
                }
                if (name.isEmpty()) {
                    name = entity.getItemValueString("_kurzbezeichnung");
                }
                if (name.isEmpty()) {
                    name = entity.getItemValueString(keyValue);
                }
                entity.setItemValue("_name", (Object)name);
                String masterKey = consultenID + "_" + clientID + "_" + keyValue;
                entity.setItemValue("name", (Object)masterKey);
                idCache.add((CallSite)((Object)masterKey));
                ItemCollection oldEntity = this.findEntityByPrimaryKey(masterKey, type);
                if (oldEntity == null) {
                    this.saveEntry(entity, type, clientID, consultenID);
                    ++workitemsImported;
                } else if (!this.isEqualEntity(oldEntity, entity, fields)) {
                    logger.fine("update existing entity: " + oldEntity.getUniqueID());
                    oldEntity.replaceAllItems(entity.getAllItems());
                    this.saveEntry(oldEntity, type, clientID, consultenID);
                    ++workitemsUpdated;
                }
                if (blockSize < 100) continue;
                blockSize = 0;
                logger.info(workitemsTotal + " entries read....");
            }
        }
        catch (Exception e) {
            ++workitemsFailed;
            String sError = "import error at line " + line + ": " + String.valueOf(e) + " Datensatz=" + dataLine;
            this.log(log, sError);
            throw new PluginException(DatevImportService.class.getName(), "DATEV_DATA_ERROR", sError, e);
        }
        finally {
            try {
                if (imputStream != null) {
                    imputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            List entries;
            this.log(log, "\u251c\u2500\u2500 L\u00f6sche veraltete Daten...");
            String sQuery = "(type:\"" + type + "\"";
            if (clientID != null && !clientID.isEmpty()) {
                sQuery = sQuery + " AND datev.client.id:\"" + clientID + "\"";
            }
            if ((entries = this.documentService.find(sQuery = sQuery + ")", 999, 0)) != null && entries.size() > 0) {
                for (ItemCollection entity : entries) {
                    String id = entity.getItemValueString("name");
                    if (idCache.contains(id)) continue;
                    this.documentService.remove(entity);
                    ++workitemsDeleted;
                }
            }
        }
        catch (QueryException e) {
            String sError = "import error: unable to delete data";
            this.log(log, sError);
            throw new PluginException(DatevImportService.class.getName(), "DATEV_DATA_ERROR", sError, (Exception)((Object)e));
        }
        this.log(log, "\u2514\u2500\u2500 Abgeschlossen in " + (System.currentTimeMillis() - l) + " ms");
        this.log(log, "\u2502\u00a0\u00a0 \u251c\u2500\u2500 " + workitemsTotal + " Eintr\u00e4ge gelesen ");
        this.log(log, "\u2502\u00a0\u00a0 \u251c\u2500\u2500 " + workitemsImported + " neue Eintr\u00e4ge  ");
        this.log(log, "\u2502\u00a0\u00a0 \u251c\u2500\u2500 " + workitemsUpdated + " aktualisierte Eintr\u00e4ge  ");
        this.log(log, "\u2502\u00a0\u00a0 \u251c\u2500\u2500 " + workitemsDeleted + " gel\u00f6schte Eintr\u00e4ge  ");
        this.log(log, "\u2502\u00a0\u00a0 \u2514\u2500\u2500 " + workitemsFailed + " fehlerhafte Eintr\u00e4ge  ");
        return log.toString();
    }

    private void log(StringBuffer log, String message) {
        log.append(message + "\n");
        logger.info(message);
    }

    public String[] normalizeValueList(String[] data) {
        for (int i = 0; i < data.length; ++i) {
            String value = data[i];
            if (!value.startsWith("\"") || !value.endsWith("\"")) continue;
            data[i] = value = value.substring(1, value.length() - 1);
        }
        return data;
    }

    public List<String> parseFieldList(String data) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(data, ";");
        while (st.hasMoreTokens()) {
            String field = st.nextToken().trim();
            if (!field.isEmpty()) {
                field = field.replace(".", "");
                field = field.replace(' ', '_');
                field = field.replace('/', '_');
                field = field.replace('\\', '_');
                field = field.replace('.', '_');
                field = field.replace('>', '_');
                field = field.replace('<', '_');
                field = field.replace('&', '_');
                result.add("_" + field.trim());
                continue;
            }
            result.add(null);
        }
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void saveEntry(ItemCollection aWorkitem, String type, String clientID, String consultenID) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        String summary;
        aWorkitem.replaceItemValue("type", (Object)type);
        aWorkitem.replaceItemValue("datev.client.id", (Object)clientID);
        aWorkitem.replaceItemValue("datev.consultant.id", (Object)consultenID);
        aWorkitem.setItemValue("$nosnapshot", (Object)true);
        if ("kontenbeschriftungen".equals(type)) {
            summary = aWorkitem.getItemValueString("_konto") + " " + aWorkitem.getItemValueString("_kontobeschriftung");
            aWorkitem.setItemValue("$workflowsummary", (Object)summary);
        }
        if ("debitoren/kreditoren".equals(type)) {
            summary = aWorkitem.getItemValueString("_konto") + " " + aWorkitem.getItemValueString("_name");
            aWorkitem.setItemValue("$workflowsummary", (Object)summary);
        }
        this.documentService.save(aWorkitem);
    }

    public ItemCollection readEntity(String data, List<String> fieldnames) {
        ItemCollection result = new ItemCollection();
        int iCol = 0;
        String[] valuList = data.split(";(?=([^\"]*\"[^\"]*\")*[^\"]*$)", 999);
        for (String itemValue : valuList = this.normalizeValueList(valuList)) {
            if ((itemValue = itemValue.trim()) != null && !itemValue.isEmpty()) {
                result.replaceItemValue(fieldnames.get(iCol), (Object)itemValue);
            } else {
                result.replaceItemValue(fieldnames.get(iCol), (Object)"");
            }
            if (++iCol >= fieldnames.size()) break;
        }
        return result;
    }

    private boolean isEqualEntity(ItemCollection oldEntity, ItemCollection entity, List<String> fields) {
        if (!entity.getItemValue("datev.client.id").equals(oldEntity.getItemValue("datev.client.id"))) {
            return false;
        }
        if (!entity.getItemValue("datev.consultant.id").equals(oldEntity.getItemValue("datev.consultant.id"))) {
            return false;
        }
        if (!entity.getItemValue("name").equals(oldEntity.getItemValue("name"))) {
            return false;
        }
        for (String itemName : fields) {
            if (entity.getItemValue(itemName).equals(oldEntity.getItemValue(itemName))) continue;
            return false;
        }
        return true;
    }
}

