/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.einvoice;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.imixs.workflow.ItemCollection;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class UBLParser {
    private static Logger logger = Logger.getLogger(UBLParser.class.getName());
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    public static Document parseInputStream(InputStream xmlInputStream) {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            doc = documentBuilder.parse(xmlInputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static void parseItems(Document doc, ItemCollection workitem) throws XPathExpressionException {
        XPath xpath = UBLParser.createXPath(doc);
        UBLParser.readXMLValue(doc, xpath, "/ubl:Invoice/cbc:ID/text()", workitem, "invoice.number", String.class);
        UBLParser.readXMLValue(doc, xpath, "/ubl:Invoice/cbc:IssueDate/text()", workitem, "invoice.date", Date.class);
    }

    private static <T> void readXMLValue(Document doc, XPath xpath, String expression, ItemCollection workitem, String itemName, Class<T> itemType) throws XPathExpressionException {
        XPathExpression expr = xpath.compile(expression);
        String value = (String)expr.evaluate(doc, XPathConstants.STRING);
        if (itemType == Date.class) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            formatter.setTimeZone(TimeZone.getTimeZone("CET"));
            try {
                workitem.setItemValue(itemName, (Object)formatter.parse(value));
            }
            catch (ParseException e) {
                logger.warning("Invalid Date Format");
            }
            return;
        }
        if (itemType == Double.class && value != null && !value.isEmpty()) {
            workitem.setItemValue(itemName, (Object)Double.parseDouble(value));
            return;
        }
        if (itemType == Integer.class && value != null && !value.isEmpty()) {
            workitem.setItemValue(itemName, (Object)Integer.parseInt(value));
            return;
        }
        workitem.setItemValue(itemName, (Object)value);
    }

    private static XPath createXPath(Document doc) {
        final Map<String, String> namespaces = UBLParser.extractNamespaces(doc);
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return (String)namespaces.get(prefix);
            }

            @Override
            public String getPrefix(String uri) {
                for (Map.Entry entry : namespaces.entrySet()) {
                    if (!((String)entry.getValue()).equals(uri)) continue;
                    return (String)entry.getKey();
                }
                return null;
            }

            public Iterator getPrefixes(String uri) {
                return null;
            }
        });
        return xpath;
    }

    private static Map<String, String> extractNamespaces(Document doc) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        NamedNodeMap attributes = doc.getDocumentElement().getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            String nodeName = node.getNodeName();
            if (!nodeName.startsWith("xmlns:")) continue;
            String prefix = nodeName.substring(6);
            namespaces.put(prefix, node.getNodeValue());
        }
        return namespaces;
    }
}

